from __future__ import print_function
import os, sys, re, subprocess

# define modules runtime quarantine configuration
os.environ['MODULES_RUN_QUARANTINE'] = 'LD_LIBRARY_PATH LD_PRELOAD'

# setup quarantine if defined
_mlre = os.environ.copy()
if 'MODULES_RUN_QUARANTINE' in os.environ:
   for _mlv in os.environ['MODULES_RUN_QUARANTINE'].split():
      if re.match('^[A-Za-z_][A-Za-z0-9_]*$', _mlv):
         if _mlv in os.environ:
            _mlre['__MODULES_QUAR_' + _mlv] = os.environ[_mlv]
         _mlrv = 'MODULES_RUNENV_' + _mlv
         if _mlrv in os.environ:
            _mlre[_mlv] = os.environ[_mlrv]
         else:
            _mlre[_mlv] = ''
   _mlre['__MODULES_QUARANTINE_SET'] = '1'

# define module command and surrounding initial environment (default value
# for MODULESHOME, MODULEPATH, LOADEDMODULES and parse of init config files)
out, err = subprocess.Popen(['/usr/bin/tclsh', '/usr/share/Modules/libexec/modulecmd.tcl', 'python', 'autoinit'], stdout=subprocess.PIPE, stderr=subprocess.PIPE, env=_mlre).communicate()

exec(out)
if err.decode():
   print(err.decode(), end='', file=sys.stderr)

# clean temp variables
del _mlre
del out
del err
