<?php
class Redux_Options_typography {

	/**
	 * Field Constructor.
	 *
	 * Required - must call the parent constructor, then assign field and value to vars, and obviously call the render field function
	 *
	 * @since Redux_Options 1.0.0
	*/
	
	function __construct($parent, $field = array(), $value = '') {
		$this->field = $field;
		$this->value = $value;
		$this->args = $parent->args;
	}


	/**
	 * Field Render Function.
	 *
	 * Takes the vars and outputs the HTML for the field in the settings
	 *
	 * @since Redux_Options 1.0.0
	*/
	function render() {
		$class = (isset($this->field['class'])) ? $this->field['class'] : '';
		$this->value = wp_parse_args( $this->value, $this->field['std'] );
		?>
		<div class="field-typography">
			<div>
				<span><?php esc_html_e( 'Family / Color', 'maxhost' ); ?></span>

				<select class="" name="<?php echo esc_attr( $this->args['opt_name'].'['.$this->field['id'].']' ); ?>[family]" id="<?php echo esc_attr( $this->field['id'] ); ?>-family" title="Font Family">
					<optgroup label="<?php esc_html_e( 'Default Fonts', 'maxhost' ); ?>">
						<?php $this->_vw_render_default_font_option( $this->value['family'] ); ?>
					</optgroup>
					<optgroup label="<?php esc_html_e( 'Google Fonts', 'maxhost' ); ?>">
						<?php $this->_vw_render_google_font_option( $this->value['family'] ); ?>
					</optgroup>
				</select>

				<?php
				if(get_bloginfo('version') >= '3.5') {
					echo '<input type="text" id="' . $this->field['id'] . '-color" name="' . $this->args['opt_name'] . '[' . $this->field['id'] . '][color]" value="' . $this->value['color'] . '" class="' . $class . ' popup-colorpicker" style="width:70px;" data-default-color="' . esc_attr($this->value['color']) . '"/>';
					echo (isset($this->field['desc']) && !empty($this->field['desc']))?' <span class="description">'.$this->field['desc'].'</span>':'';
				} else {
					echo '<div class="farb-popup-wrapper" id="' . $this->field['id'] . '">';
					echo '<input type="text" id="' . $this->field['id'] . '-color" name="' . $this->args['opt_name'] . '[' . $this->field['id'] . '][color]" value="' . $this->value['color'] . '" class="' . $class . ' popup-colorpicker" style="width:70px;"/>';
					echo '<div class="farb-popup"><div class="farb-popup-inside"><div id="' . $this->field['id'] . '-colorpicker" class="color-picker"></div></div></div>';
					echo (isset($this->field['desc']) && !empty($this->field['desc'])) ? ' <span class="description">' . $this->field['desc'] . '</span>' : '';
					echo '</div>';
				}

				?>
			</div>
			<div style="margin-top: 10px;">
				<?php if ( ! isset( $this->field['size'] ) || ( isset( $this->field['size'] ) && $this->field['size'] !== false ) ) : ?>
					<span><?php esc_html_e( 'Size / Weight', 'maxhost' ); ?></span>
					<select class="" name="<?php echo esc_attr( $this->args['opt_name'].'['.$this->field['id'].']' ); ?>[size]" id="<?php echo esc_attr( $this->field['id'] ); ?>-size" title="Font Size">
						<?php $this->_vw_render_font_size_option( $this->value['size'] ); ?>
					</select>
				<?php else : ?>
					<span><?php esc_html_e( 'Weight', 'maxhost' ); ?></span>
				<?php endif; ?>
				
				<select class="" name="<?php echo esc_attr( $this->args['opt_name'].'['.$this->field['id'].']' ); ?>[weight]" id="<?php echo esc_attr( $this->field['id'] ); ?>-weight" title="Font Weight">
					<option value="300" <?php selected( $this->value['weight'], 300 ) ?>>Light (300)</option>
					<option value="400" <?php selected( $this->value['weight'], 400 ) ?>>Normal (400)</option>
					<option value="600" <?php selected( $this->value['weight'], 600 ) ?>>Semi-Bold (600)</option>
					<option value="700" <?php selected( $this->value['weight'], 700 ) ?>>Bold (700)</option>
					<option value="800" <?php selected( $this->value['weight'], 800 ) ?>>Extra-Bold (800)</option>
				</select>
			</div>
		</div>
		<?php
	}

	/**
	 * Enqueue Function.
	 *
	 * If this field requires any scripts, or css define this function and register/enqueue the scripts/css
	 *
	 * @since Redux_Options 1.0.0
	*/
	function enqueue() {
		if(get_bloginfo('version') >= '3.5') {
			wp_enqueue_style('wp-color-picker');
			wp_enqueue_script(
				'redux-opts-field-color-js',
				Redux_OPTIONS_URL . 'fields/color/field_color.js',
				array('wp-color-picker'),
				time(),
				true
			);
		} else {
			wp_enqueue_script(
				'redux-opts-field-color-js', 
				Redux_OPTIONS_URL . 'fields/color/field_color_farb.js', 
				array('jquery', 'farbtastic'),
				time(),
				true
			);
		}
	}

	/**
	 * Render <option> Helper
	 */
	function _vw_option( $options, $current ) {
		foreach ( $options as $value => $option ) {
			if ( is_numeric( $value ) ) $value = $option;
			echo '<option value="' . $value . '" ' . selected( $current, $value ) . '>';
			echo esc_attr( $option );
			echo '</option>';
		}
	}

	function _vw_render_font_size_option( $current ) {
		$sizes = array(
			'9px',
			'10px',
			'11px',
			'12px',
			'13px',
			'14px',
			'15px',
			'16px',
			'17px',
			'18px',
			'19px',
			'20px',
			'21px',
			'22px',
			'23px',
			'24px',
			'25px',
			'26px',
			'27px',
			'28px',
			'29px',
			'30px',
			'31px',
			'32px',
			'33px',
			'34px',
			'35px',
			'36px',
			'37px',
			'38px',
			'39px',
			'40px',
			'41px',
			'42px',
			'43px',
			'44px',
			'45px',
			'46px'
		);

		$this->_vw_option( $sizes, $current );
	}

	function _vw_render_default_font_option( $current ) {
		$fonts = array(
			"'Custom Font 1'" => 'Custom Font 1',
			"'Custom Font 2'" => 'Custom Font 2',
			"Arial, 'Helvetica Neue', Helvetica" => 'Arial, Helvetica Neue, Helvetica',
			"'Arial Narrow', Arial" => 'Arial Narrow, Arial',
			"'Century Gothic', CenturyGothic, AppleGothic" => 'Century Gothic, CenturyGothic, AppleGothic',
			"'Helvetica Neue', Helvetica, Arial" => 'Helvetica Neue, Helvetica, Arial',
			"Georgia, Times, 'Times New Roman', serif" => 'Georgia, Times, Times New Roman, serif',
			"Palatino, 'Palatino Linotype', 'Palatino LT STD', 'Book Antiqua', Georgia, serif" => 'Palatino, Book Antiqua, Georgia, serif',
			"Verdana, Geneva" => 'Verdana, Geneva',
			"Tahoma, Verdana, Segoe" => 'Tahoma, Verdana, Segoe',
			"TimesNewRoman, 'Times New Roman', Times, Baskerville, Georgia, serif" => 'Times New Roman, Times, Baskerville, Georgia, serif',
			"'Trebuchet MS', 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', Tahoma, sans-serif" => 'Trebuchet MS, Lucida Grande, Lucida Sans, Tahoma',
		);

		$this->_vw_option( $fonts, $current );
	}

	function _vw_render_google_font_option( $current ) {
		$fonts = array(
			'ABeeZee',
			'Abel',
			'Abril Fatface',
			'Aclonica',
			'Acme',
			'Actor',
			'Adamina',
			'Advent Pro',
			'Aguafina Script',
			'Akronim',
			'Aladin',
			'Aldrich',
			'Alef',
			'Alegreya',
			'Alegreya SC',
			'Alex Brush',
			'Alfa Slab One',
			'Alice',
			'Alike',
			'Alike Angular',
			'Allan',
			'Allerta',
			'Allerta Stencil',
			'Allura',
			'Almendra',
			'Almendra Display',
			'Almendra SC',
			'Amarante',
			'Amaranth',
			'Amatic SC',
			'Amethysta',
			'Anaheim',
			'Andada',
			'Andika',
			'Angkor',
			'Annie Use Your Telescope',
			'Anonymous Pro',
			'Antic',
			'Antic Didone',
			'Antic Slab',
			'Anton',
			'Arapey',
			'Arbutus',
			'Arbutus Slab',
			'Architects Daughter',
			'Archivo Black',
			'Archivo Narrow',
			'Arimo',
			'Arizonia',
			'Armata',
			'Artifika',
			'Arvo',
			'Asap',
			'Asset',
			'Astloch',
			'Asul',
			'Atomic Age',
			'Aubrey',
			'Audiowide',
			'Autour One',
			'Average',
			'Average Sans',
			'Averia Gruesa Libre',
			'Averia Libre',
			'Averia Sans Libre',
			'Averia Serif Libre',
			'Bad Script',
			'Balthazar',
			'Bangers',
			'Basic',
			'Battambang',
			'Baumans',
			'Bayon',
			'Belgrano',
			'Belleza',
			'BenchNine',
			'Bentham',
			'Berkshire Swash',
			'Bevan',
			'Bigelow Rules',
			'Bigshot One',
			'Bilbo',
			'Bilbo Swash Caps',
			'Bitter',
			'Black Ops One',
			'Bokor',
			'Bonbon',
			'Boogaloo',
			'Bowlby One',
			'Bowlby One SC',
			'Brawler',
			'Bree Serif',
			'Bubblegum Sans',
			'Bubbler One',
			'Buda',
			'Buenard',
			'Butcherman',
			'Butterfly Kids',
			'Cabin',
			'Cabin Condensed',
			'Cabin Sketch',
			'Caesar Dressing',
			'Cagliostro',
			'Calligraffitti',
			'Cambo',
			'Candal',
			'Cantarell',
			'Cantata One',
			'Cantora One',
			'Capriola',
			'Cardo',
			'Carme',
			'Carrois Gothic',
			'Carrois Gothic SC',
			'Carter One',
			'Caudex',
			'Cedarville Cursive',
			'Ceviche One',
			'Changa One',
			'Chango',
			'Chau Philomene One',
			'Chela One',
			'Chelsea Market',
			'Chenla',
			'Cherry Cream Soda',
			'Cherry Swash',
			'Chewy',
			'Chicle',
			'Chivo',
			'Cinzel',
			'Cinzel Decorative',
			'Clicker Script',
			'Coda',
			'Coda Caption',
			'Codystar',
			'Combo',
			'Comfortaa',
			'Coming Soon',
			'Concert One',
			'Condiment',
			'Content',
			'Contrail One',
			'Convergence',
			'Cookie',
			'Copse',
			'Corben',
			'Courgette',
			'Cousine',
			'Coustard',
			'Covered By Your Grace',
			'Crafty Girls',
			'Creepster',
			'Crete Round',
			'Crimson Text',
			'Croissant One',
			'Crushed',
			'Cuprum',
			'Cutive',
			'Cutive Mono',
			'Damion',
			'Dancing Script',
			'Dangrek',
			'Dawning of a New Day',
			'Days One',
			'Delius',
			'Delius Swash Caps',
			'Delius Unicase',
			'Della Respira',
			'Denk One',
			'Devonshire',
			'Didact Gothic',
			'Diplomata',
			'Diplomata SC',
			'Domine',
			'Donegal One',
			'Doppio One',
			'Dorsa',
			'Dosis',
			'Dr Sugiyama',
			'Droid Sans',
			'Droid Sans Mono',
			'Droid Serif',
			'Duru Sans',
			'Dynalight',
			'EB Garamond',
			'Eagle Lake',
			'Eater',
			'Economica',
			'Electrolize',
			'Elsie',
			'Elsie Swash Caps',
			'Emblema One',
			'Emilys Candy',
			'Engagement',
			'Englebert',
			'Enriqueta',
			'Erica One',
			'Esteban',
			'Euphoria Script',
			'Ewert',
			'Exo',
			'Expletus Sans',
			'Fanwood Text',
			'Fascinate',
			'Fascinate Inline',
			'Faster One',
			'Fasthand',
			'Federant',
			'Federo',
			'Felipa',
			'Fenix',
			'Finger Paint',
			'Fjalla One',
			'Fjord One',
			'Flamenco',
			'Flavors',
			'Fondamento',
			'Fontdiner Swanky',
			'Forum',
			'Francois One',
			'Freckle Face',
			'Fredericka the Great',
			'Fredoka One',
			'Freehand',
			'Fresca',
			'Frijole',
			'Fruktur',
			'Fugaz One',
			'GFS Didot',
			'GFS Neohellenic',
			'Gabriela',
			'Gafata',
			'Galdeano',
			'Galindo',
			'Gentium Basic',
			'Gentium Book Basic',
			'Geo',
			'Geostar',
			'Geostar Fill',
			'Germania One',
			'Gilda Display',
			'Give You Glory',
			'Glass Antiqua',
			'Glegoo',
			'Gloria Hallelujah',
			'Goblin One',
			'Gochi Hand',
			'Gorditas',
			'Goudy Bookletter 1911',
			'Graduate',
			'Grand Hotel',
			'Gravitas One',
			'Great Vibes',
			'Griffy',
			'Gruppo',
			'Gudea',
			'Habibi',
			'Hammersmith One',
			'Hanalei',
			'Hanalei Fill',
			'Handlee',
			'Hanuman',
			'Happy Monkey',
			'Headland One',
			'Henny Penny',
			'Herr Von Muellerhoff',
			'Holtwood One SC',
			'Homemade Apple',
			'Homenaje',
			'IM Fell DW Pica',
			'IM Fell DW Pica SC',
			'IM Fell Double Pica',
			'IM Fell Double Pica SC',
			'IM Fell English',
			'IM Fell English SC',
			'IM Fell French Canon',
			'IM Fell French Canon SC',
			'IM Fell Great Primer',
			'IM Fell Great Primer SC',
			'Iceberg',
			'Iceland',
			'Imprima',
			'Inconsolata',
			'Inder',
			'Indie Flower',
			'Inika',
			'Irish Grover',
			'Istok Web',
			'Italiana',
			'Italianno',
			'Jacques Francois',
			'Jacques Francois Shadow',
			'Jim Nightshade',
			'Jockey One',
			'Jolly Lodger',
			'Josefin Sans',
			'Josefin Slab',
			'Joti One',
			'Judson',
			'Julee',
			'Julius Sans One',
			'Junge',
			'Jura',
			'Just Another Hand',
			'Just Me Again Down Here',
			'Kameron',
			'Karla',
			'Kaushan Script',
			'Kavoon',
			'Keania One',
			'Kelly Slab',
			'Kenia',
			'Khmer',
			'Kite One',
			'Knewave',
			'Kotta One',
			'Koulen',
			'Kranky',
			'Kreon',
			'Kristi',
			'Krona One',
			'La Belle Aurore',
			'Lancelot',
			'Lato',
			'League Script',
			'Leckerli One',
			'Ledger',
			'Lekton',
			'Lemon',
			'Libre Baskerville',
			'Life Savers',
			'Lilita One',
			'Limelight',
			'Linden Hill',
			'Lobster',
			'Lobster Two',
			'Londrina Outline',
			'Londrina Shadow',
			'Londrina Sketch',
			'Londrina Solid',
			'Lora',
			'Love Ya Like A Sister',
			'Loved by the King',
			'Lovers Quarrel',
			'Luckiest Guy',
			'Lusitana',
			'Lustria',
			'Macondo',
			'Macondo Swash Caps',
			'Magra',
			'Maiden Orange',
			'Mako',
			'Marcellus',
			'Marcellus SC',
			'Marck Script',
			'Margarine',
			'Marko One',
			'Marmelad',
			'Marvel',
			'Mate',
			'Mate SC',
			'Maven Pro',
			'McLaren',
			'Meddon',
			'MedievalSharp',
			'Medula One',
			'Megrim',
			'Meie Script',
			'Merienda',
			'Merienda One',
			'Merriweather',
			'Merriweather Sans',
			'Metal',
			'Metal Mania',
			'Metamorphous',
			'Metrophobic',
			'Michroma',
			'Milonga',
			'Miltonian',
			'Miltonian Tattoo',
			'Miniver',
			'Miss Fajardose',
			'Modern Antiqua',
			'Molengo',
			'Molle',
			'Monda',
			'Monofett',
			'Monoton',
			'Monsieur La Doulaise',
			'Montaga',
			'Montez',
			'Montserrat',
			'Montserrat Alternates',
			'Montserrat Subrayada',
			'Moul',
			'Moulpali',
			'Mountains of Christmas',
			'Mouse Memoirs',
			'Mr Bedfort',
			'Mr Dafoe',
			'Mr De Haviland',
			'Mrs Saint Delafield',
			'Mrs Sheppards',
			'Muli',
			'Mystery Quest',
			'Neucha',
			'Neuton',
			'New Rocker',
			'News Cycle',
			'Niconne',
			'Nixie One',
			'Nobile',
			'Nokora',
			'Norican',
			'Nosifer',
			'Nothing You Could Do',
			'Noticia Text',
			'Noto Sans',
			'Noto Serif',
			'Nova Cut',
			'Nova Flat',
			'Nova Mono',
			'Nova Oval',
			'Nova Round',
			'Nova Script',
			'Nova Slim',
			'Nova Square',
			'Numans',
			'Nunito',
			'Odor Mean Chey',
			'Offside',
			'Old Standard TT',
			'Oldenburg',
			'Oleo Script',
			'Oleo Script Swash Caps',
			'Open Sans',
			'Open Sans Condensed',
			'Oranienbaum',
			'Orbitron',
			'Oregano',
			'Orienta',
			'Original Surfer',
			'Oswald',
			'Over the Rainbow',
			'Overlock',
			'Overlock SC',
			'Ovo',
			'Oxygen',
			'Oxygen Mono',
			'PT Mono',
			'PT Sans',
			'PT Sans Caption',
			'PT Sans Narrow',
			'PT Serif',
			'PT Serif Caption',
			'Pacifico',
			'Paprika',
			'Parisienne',
			'Passero One',
			'Passion One',
			'Patrick Hand',
			'Patrick Hand SC',
			'Patua One',
			'Paytone One',
			'Peralta',
			'Permanent Marker',
			'Petit Formal Script',
			'Petrona',
			'Philosopher',
			'Piedra',
			'Pinyon Script',
			'Pirata One',
			'Plaster',
			'Play',
			'Playball',
			'Playfair Display',
			'Playfair Display SC',
			'Podkova',
			'Poiret One',
			'Poller One',
			'Poly',
			'Pompiere',
			'Pontano Sans',
			'Port Lligat Sans',
			'Port Lligat Slab',
			'Prata',
			'Preahvihear',
			'Press Start 2P',
			'Princess Sofia',
			'Prociono',
			'Prosto One',
			'Puritan',
			'Purple Purse',
			'Quando',
			'Quantico',
			'Quattrocento',
			'Quattrocento Sans',
			'Questrial',
			'Quicksand',
			'Quintessential',
			'Qwigley',
			'Racing Sans One',
			'Radley',
			'Raleway',
			'Raleway Dots',
			'Rambla',
			'Rammetto One',
			'Ranchers',
			'Rancho',
			'Rationale',
			'Redressed',
			'Reenie Beanie',
			'Revalia',
			'Ribeye',
			'Ribeye Marrow',
			'Righteous',
			'Risque',
			'Roboto',
			'Roboto Condensed',
			'Roboto Slab',
			'Rochester',
			'Rock Salt',
			'Rokkitt',
			'Romanesco',
			'Ropa Sans',
			'Rosario',
			'Rosarivo',
			'Rouge Script',
			'Ruda',
			'Rufina',
			'Ruge Boogie',
			'Ruluko',
			'Rum Raisin',
			'Ruslan Display',
			'Russo One',
			'Ruthie',
			'Rye',
			'Sacramento',
			'Sail',
			'Salsa',
			'Sanchez',
			'Sancreek',
			'Sansita One',
			'Sarina',
			'Satisfy',
			'Scada',
			'Schoolbell',
			'Seaweed Script',
			'Sevillana',
			'Seymour One',
			'Shadows Into Light',
			'Shadows Into Light Two',
			'Shanti',
			'Share',
			'Share Tech',
			'Share Tech Mono',
			'Shojumaru',
			'Short Stack',
			'Siemreap',
			'Sigmar One',
			'Signika',
			'Signika Negative',
			'Simonetta',
			'Sintony',
			'Sirin Stencil',
			'Six Caps',
			'Skranji',
			'Slackey',
			'Smokum',
			'Smythe',
			'Sniglet',
			'Snippet',
			'Snowburst One',
			'Sofadi One',
			'Sofia',
			'Sonsie One',
			'Sorts Mill Goudy',
			'Source Code Pro',
			'Source Sans Pro',
			'Special Elite',
			'Spicy Rice',
			'Spinnaker',
			'Spirax',
			'Squada One',
			'Stalemate',
			'Stalinist One',
			'Stardos Stencil',
			'Stint Ultra Condensed',
			'Stint Ultra Expanded',
			'Stoke',
			'Strait',
			'Sue Ellen Francisco',
			'Sunshiney',
			'Supermercado One',
			'Suwannaphum',
			'Swanky and Moo Moo',
			'Syncopate',
			'Tangerine',
			'Taprom',
			'Tauri',
			'Telex',
			'Tenor Sans',
			'Text Me One',
			'The Girl Next Door',
			'Tienne',
			'Tinos',
			'Titan One',
			'Titillium Web',
			'Trade Winds',
			'Trocchi',
			'Trochut',
			'Trykker',
			'Tulpen One',
			'Ubuntu',
			'Ubuntu Condensed',
			'Ubuntu Mono',
			'Ultra',
			'Uncial Antiqua',
			'Underdog',
			'Unica One',
			'UnifrakturCook',
			'UnifrakturMaguntia',
			'Unkempt',
			'Unlock',
			'Unna',
			'VT323',
			'Vampiro One',
			'Varela',
			'Varela Round',
			'Vast Shadow',
			'Vibur',
			'Vidaloka',
			'Viga',
			'Voces',
			'Volkhov',
			'Vollkorn',
			'Voltaire',
			'Waiting for the Sunrise',
			'Wallpoet',
			'Walter Turncoat',
			'Warnes',
			'Wellfleet',
			'Wendy One',
			'Wire One',
			'Yanone Kaffeesatz',
			'Yellowtail',
			'Yeseva One',
			'Yesteryear',
			'Zeyada'
		);

		$this->_vw_option( $fonts, $current );
	}
}
