/*!
 * Include this js file after bootstrap.min. If users click on the body, the menu will close.
 */
(function($) {

	"use strict";
	
	$(document).ready(function () {

		$('#navbar-collapse-1').on('shown.bs.collapse', function () { //#navbar-collapse-1 is the ID of the navigation container div
			
			$(document).on('click', function(event) {
				if ($(event.target).closest('#navbar-collapse-1').length) return
				if (!$('#navbar-collapse-1').hasClass('in')) return
				$('#navbar-collapse-1').attr('aria-expanded', false)
				$('#navbar-collapse-1').removeClass('collapse in')
				$('#navbar-collapse-1').addClass('collapsing')
				$('#navbar-collapse-1').addClass('collapse')
				$('#navbar-collapse-1').removeClass('collapsing')
			});
		});
		
		//JS to make the onclick dropdown for main nav in mobile
		const dropdowns = $('#navbar-collapse-1 .menu-item-has-children');
  
		  if ($(window).width() < 999) {
		  dropdowns.each(function() {
			const dropdownMenu = $(this).find('.dropdown-menu');
				const parentLink = $(this).find('.menu-link.dropdown-toggle');
				const parentItem = $(this);
				
				if (parentItem.hasClass('menu-item-has-children')) {
					parentLink.click(function(event) {
						event.preventDefault();
						if (dropdownMenu.hasClass('active')) {
							dropdownMenu.removeClass('active');
							parentItem.removeClass('this-parent-is-active');
						} else {
							dropdownMenu.addClass('active'); //Adding 'active' class on the active link
							parentItem.addClass('this-parent-is-active'); //Adding 'this-parent-is-active' class on the active parent menu li element
						}
					});
				}
		  });
		  }
		  //And the following css needs to be used in a css file:
			/*
			@media (max-width: 999px){
				#menu-main-menu .dropdown .dropdown-menu{display: none;}
				#menu-main-menu .dropdown .dropdown-menu.active{display:block;}
				.header .menu-item-has-children .dropdown-toggle::after {
					content: '';
					display: inline-block !important;
					vertical-align: middle;
					float: right;
					border: solid #fff;
					border-width: 0 2px 2px 0;
					padding: 2.5px;
					transform: rotate(45deg) !important;
					align-items: center;
					margin-top: 3px;
					margin-right: 5px;
				}
				.header .menu-item-has-children.this-parent-is-active .dropdown-toggle::after {
					transform: rotate(-135deg) !important;
					margin-top: 8px;
				}
			}
			*/
	});
}(jQuery));