<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Domain_Search extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_domain_search';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Domain Search Block', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-form-vertical';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__( 'Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'section_style',
            [
                'label'     => esc_html__('Choose Style', 'maxhost'),
                'type' => \Elementor\Controls_Manager::SELECT,
				'options'   => [
                    '' => esc_html__('Choose Style', 'maxhost'),
                    'm-top0 domain-search shape-white' => esc_html__('Style One', 'maxhost'),
					'm-top0 domain-search' => esc_html__('Style Two', 'maxhost'),
					'm-top5 m-bottom5' => esc_html__('Style Three', 'maxhost'),
					'm-top0 domain-search white-bg' => esc_html__('Style Four', 'maxhost'),
					'domain-page-header m-top0' => esc_html__('Style Five', 'maxhost'),
                ],
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'section_heading1',
            [
                'label'     => esc_html__( 'Section Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                "description" => esc_html__('Section Heading needed for Style Two, Style Three and Style Five.', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'search_pholder',
            [
                'label'     => esc_html__( 'Search Field Place Holder Text', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'button_label',
            [
                'label'     => esc_html__( 'Search Button Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'search_action_url',
            [
                'label'     => esc_html__( 'Search Action URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Put your WHMCS domain search url. Example: YOUR_WHMCS_SITE_URL/cart.php?a=add&domain=register&query= And,
			if you are using this for Transfer domain, then the url will be like this: YOUR_WHMCS_SITE_URL/cart.php?a=add&domain=transfer&query=', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'domain',
            [
                'label'     => esc_html__( 'Domain TLDs', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__("Input each tld on new line. Keep this field empty if you are using Style Four.", 'maxhost'),
                'default' => '',
            ]
        );
		
		$this->add_control(
            'ajax_search',
            [
                'label'     => esc_html__( 'Enable Ajax Domain Search', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'description' => esc_html__("It will show the Domain Search result below the Search Form.", 'maxhost'),
				'return_value' => 'false',
				'default' => 'false',
            ]
        );
		
		$this->add_control(
            'purchase_btn_name',
            [
                'label'     => esc_html__( 'Ajax Search Purchase Button Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'sample_domain1',
            [
                'label'     => esc_html__( 'Sample Domain - 1', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Example: .com', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'sample_domain1_pricing',
            [
                'label'     => esc_html__( 'Sample Domain - 1 Pricing', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Example: $9', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'sample_domain2',
            [
                'label'     => esc_html__( 'Sample Domain - 2', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Example: .com', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'sample_domain2_pricing',
            [
                'label'     => esc_html__( 'Sample Domain - 2 Pricing', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Example: $9', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'sample_domain3',
            [
                'label'     => esc_html__( 'Sample Domain - 3', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Example: .com', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'sample_domain3_pricing',
            [
                'label'     => esc_html__( 'Sample Domain - 3 Pricing', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Example: $9', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'sample_domain4',
            [
                'label'     => esc_html__( 'Sample Domain - 4', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Example: .com', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'sample_domain4_pricing',
            [
                'label'     => esc_html__( 'Sample Domain - 4 Pricing', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Example: $9', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'sample_domain5',
            [
                'label'     => esc_html__( 'Sample Domain - 5', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Example: .com', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'sample_domain5_pricing',
            [
                'label'     => esc_html__( 'Sample Domain - 5 Pricing', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Example: $9', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'small_note',
            [
                'label'     => esc_html__( 'Small Note', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Small Note not needed for Style Four', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'view_domain_url',
            [
                'label'     => esc_html__( 'Domain Price List URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Make a Domain Pricing page and put the page url here. Needed only for Style Four and Style Five'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'bulk_domain_url',
            [
                'label'     => esc_html__( 'Bulk Domain Search URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Example Bulk Search URL: YOUR_WHMCS_SITE_URL/domainchecker.php?search=bulk. Needed only for Style Four and Style Five', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'transfer_domain_url',
            [
                'label'     => esc_html__( 'Transfer Domain URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Example Transfer Domain URL: YOUR_WHMCS_SITE_URL/domainchecker.php?transfer=domain. Needed only for Style Four and Style Five', 'maxhost'),
                'default' => '',
				'label_block' => true,
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

        $args['section_style'] =  $settings['section_style'];
		$args['section_heading1'] =  $settings['section_heading1'];
		$args['search_pholder'] =  $settings['search_pholder'];
		$args['button_label'] =  $settings['button_label'];
		$args['search_action_url'] =  $settings['search_action_url'];
		$args['domain'] =  $settings['domain'];
		$args['ajax_search'] =  $settings['ajax_search'];
		$args['purchase_btn_name'] =  $settings['purchase_btn_name'];
		$args['sample_domain1'] =  $settings['sample_domain1'];
		$args['sample_domain2'] =  $settings['sample_domain2'];
		$args['sample_domain3'] =  $settings['sample_domain3'];
		$args['sample_domain4'] =  $settings['sample_domain4'];
		$args['sample_domain5'] =  $settings['sample_domain5'];
		$args['sample_domain1_pricing'] =  $settings['sample_domain1_pricing'];
		$args['sample_domain2_pricing'] =  $settings['sample_domain2_pricing'];
		$args['sample_domain3_pricing'] =  $settings['sample_domain3_pricing'];
		$args['sample_domain4_pricing'] =  $settings['sample_domain4_pricing'];
		$args['sample_domain5_pricing'] =  $settings['sample_domain5_pricing'];
		$args['small_note'] =  $settings['small_note'];
		$args['view_domain_url'] =  $settings['view_domain_url'];
		$args['bulk_domain_url'] =  $settings['bulk_domain_url'];
		$args['transfer_domain_url'] =  $settings['transfer_domain_url'];

       
        if( function_exists( 'maxhost_domain_search_block_shortcode' ) ) {
            echo maxhost_domain_search_block_shortcode( $args );
        }

    }

}