<?php
/**
 * Template part for displaying slider section
 *
 * @package Pharmacy Shop
 * @subpackage pharmacy_shop
 */

?>
<?php $pharmacy_shop_static_image= get_stylesheet_directory_uri() . '/assets/images/slider-img.png'; ?>
<?php if( get_theme_mod( 'pharmacy_shop_slider_arrows', true) != '') { ?>
  <section id="slider">
  <div id="carouselExampleIndicators" class="carousel slide" data-ride="carousel">
    <?php $pharmacy_shop_slide_pages = array();
      for ( $count = 1; $count <= 4; $count++ ) {
        $mod = intval( get_theme_mod( 'pharmacy_shop_slider_page' . $count ));
        if ( 'page-none-selected' != $mod ) {
          $pharmacy_shop_slide_pages[] = $mod;
        }
      }
      if( !empty($pharmacy_shop_slide_pages) ) :
        $pharmacy_shop_args = array(
          'post_type' => 'page',
          'post__in' => $pharmacy_shop_slide_pages,
          'orderby' => 'post__in'
        );
        $pharmacy_shop_query = new WP_Query( $pharmacy_shop_args );
        if ( $pharmacy_shop_query->have_posts() ) :
          $i = 1;
    ?>
    <div class="carousel-inner" role="listbox">
      <?php  while ( $pharmacy_shop_query->have_posts() ) : $pharmacy_shop_query->the_post(); ?>
        <div <?php if($i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>
          <?php if(has_post_thumbnail()){ ?>
               <img src="<?php the_post_thumbnail_url('full'); ?>"/> <?php }else {echo ('<img src="'.$pharmacy_shop_static_image.'">'); } ?>
          <div class="carousel-caption">
            <div class="inner_carousel">
              <?php if( get_theme_mod( 'pharmacy_shop_slider_short_heading' ) != '' ) { ?>
                <p class="xtra-head"><?php echo esc_html( get_theme_mod( 'pharmacy_shop_slider_short_heading','' ) ); ?></p>
              <?php } ?>
              <?php if (get_theme_mod('pharmacy_shop_show_slider_title', true)) : ?>
                <h1><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h1>
              <?php endif; ?>
              <?php if (get_theme_mod('pharmacy_shop_show_slider_content', true)) : ?>
                <p><?php $pharmacy_shop_excerpt = get_the_excerpt(); echo esc_html( pharmacy_shop_string_limit_words( $pharmacy_shop_excerpt, esc_attr(get_theme_mod('pharmacy_shop_slider_excerpt_length','20')))); ?></p>
              <?php endif; ?>
              <div class="more-btn">
                <a href="<?php the_permalink(); ?>"><i class="fas fa-shopping-basket"></i>  <?php esc_html_e('Shop Now','pharmacy-shop'); ?></a>
              </div>
            </div>
          </div>
        </div>
      <?php $i++; endwhile;
      wp_reset_postdata();?>
    </div>
    <?php else : ?>
        <div class="no-postfound"></div>
      <?php endif;
    endif;?>
    <div class="carousel-navigation">
      <div class="carousel-dots">
        <div class="carousel-dot active"></div>
        <div class="carousel-dot"></div>
        <div class="carousel-dot"></div>
        <div class="carousel-dot"></div>
      </div>
    </div>
  </div>
  <div class="clearfix"></div>
</section>

<?php } ?>
