<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Call_To_Action extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_call_to_action';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Call To Action', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-image-rollover';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__( 'Content', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'maxhost_shortcodes_parallax_bg',
            [
                'label'     => esc_html__( 'Section Background Image URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'heading1_1st',
            [
                'label'     => esc_html__( 'Heading Line-1 (Colored Part)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'heading1_2nd',
            [
                'label'     => esc_html__( 'Heading Line-1 (Simple Part)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'heading2',
            [
                'label'     => esc_html__( 'Heading Line-2', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text',
            [
                'label'     => esc_html__( 'Text Below Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'button_label',
            [
                'label'     => esc_html__( 'Button Label', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'button_url',
            [
                'label'     => esc_html__( 'Button URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

		$args['maxhost_shortcodes_parallax_bg'] =  $settings['maxhost_shortcodes_parallax_bg'];
		$args['heading1_1st'] =  $settings['heading1_1st'];
		$args['heading1_2nd'] =  $settings['heading1_2nd'];
		$args['heading2'] =  $settings['heading2'];
		$args['text'] =  $settings['text'];
		$args['button_label'] =  $settings['button_label'];
		$args['button_url'] =  $settings['button_url'];
       
        if( function_exists( 'maxhost_call_to_action_shortcode' ) ) {
            echo maxhost_call_to_action_shortcode( $args );
        }

    }

}