vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

require_once vc_path_dir( 'CONFIG_DIR', 'content/vc-custom-heading-element.php' );
$cta_custom_heading = vc_map_integrate_shortcode( vc_custom_heading_element_params(), 'custom_', esc_html__( 'Heading', 'js_composer' ), array(
	'exclude' => array(
		'source',
		'text',
		'css',
		'link',
	),
), array(
	'element' => 'use_custom_heading',
	'value' => 'true',
) );

$params = array_merge( array(
	array(
		'type' => 'textfield',
		'holder' => 'h4',
		'class' => 'vc_toggle_title',
		'heading' => esc_html__( 'Toggle title', 'js_composer' ),
		'param_name' => 'title',
		'value' => esc_html__( 'Toggle title', 'js_composer' ),
		'description' => esc_html__( 'Enter title of toggle block.', 'js_composer' ),
		'edit_field_class' => 'vc_col-sm-9',
	),
	array(
		'type' => 'checkbox',
		'heading' => esc_html__( 'Use custom font?', 'js_composer' ),
		'param_name' => 'use_custom_heading',
		'description' => esc_html__( 'Enable Google fonts.', 'js_composer' ),
		'edit_field_class' => 'vc_col-sm-3',
	),
	array(
		'type' => 'textarea_html',
		'holder' => 'div',
		'class' => 'vc_toggle_content',
		'heading' => esc_html__( 'Toggle content', 'js_composer' ),
		'param_name' => 'content',
		'value' => '<p>' . esc_html__( 'Toggle content goes here, click edit button to change this text.', 'js_composer' ) . '</p>',
		'description' => esc_html__( 'Toggle block content.', 'js_composer' ),
	),
	array(
		'type' => 'dropdown',
		'heading' => esc_html__( 'Style', 'js_composer' ),
		'param_name' => 'style',
		'value' => vc_get_shared( 'toggle styles' ),
		'description' => esc_html__( 'Select toggle design style.', 'js_composer' ),
	),
	array(
		'type' => 'dropdown',
		'heading' => esc_html__( 'Icon color', 'js_composer' ),
		'param_name' => 'color',
		'value' => array( esc_html__( 'Default', 'js_composer' ) => 'default' ) + vc_get_shared( 'colors' ),
		'description' => esc_html__( 'Select icon color.', 'js_composer' ),
		'param_holder_class' => 'vc_colored-dropdown',
	),
	array(
		'type' => 'dropdown',
		'heading' => esc_html__( 'Size', 'js_composer' ),
		'param_name' => 'size',
		'value' => array_diff_key( vc_get_shared( 'sizes' ), array( 'Mini' => '' ) ),
		'std' => 'md',
		'description' => esc_html__( 'Select toggle size', 'js_composer' ),
	),
	array(
		'type' => 'dropdown',
		'heading' => esc_html__( 'Default state', 'js_composer' ),
		'param_name' => 'open',
		'value' => array(
			esc_html__( 'Closed', 'js_composer' ) => 'false',
			esc_html__( 'Open', 'js_composer' ) => 'true',
		),
		'description' => esc_html__( 'Select "Open" if you want toggle to be open by default.', 'js_composer' ),
	),
	vc_map_add_css_animation(),
	array(
		'type' => 'el_id',
		'heading' => esc_html__( 'Element ID', 'js_composer' ),
		'param_name' => 'el_id',
		'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
	),
	array(
		'type' => 'textfield',
		'heading' => esc_html__( 'Extra class name', 'js_composer' ),
		'param_name' => 'el_class',
		'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
	),
), $cta_custom_heading, array(
	array(
		'type' => 'css_editor',
		'heading' => esc_html__( 'CSS box', 'js_composer' ),
		'param_name' => 'css',
		'group' => esc_html__( 'Design Options', 'js_composer' ),
		'value' => array(
			'margin-bottom' => '22px',
		),
	),
) );

return array(
	'name' => esc_html__( 'FAQ', 'js_composer' ),
	'base' => 'vc_toggle',
	'icon' => 'icon-wpb-toggle-small-expand',
	'element_default_class' => 'vc_do_toggle',
	'category' => esc_html__( 'Content', 'js_composer' ),
	'description' => esc_html__( 'Toggle element for Q&A block', 'js_composer' ),
	'params' => $params,
	'js_view' => 'VcToggleView',
);
vc-icon-element.php                                                                                                                                                                                                                                            9809          1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_icon] shortcode of 'Icon' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Get shortcode attributes
 *
 * @return array
 */
function vc_icon_element_params() {
	return array(
		'name' => esc_html__( 'Icon', 'js_composer' ),
		'base' => 'vc_icon',
		'icon' => 'icon-wpb-vc_icon',
		'element_default_class' => 'vc_do_icon',
		'category' => esc_html__( 'Content', 'js_composer' ),
		'description' => esc_html__( 'Eye catching icons from libraries', 'js_composer' ),
		'params' => array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'js_composer' ),
				'value' => array(
					esc_html__( 'Font Awesome 5', 'js_composer' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'js_composer' ) => 'openiconic',
					esc_html__( 'Typicons', 'js_composer' ) => 'typicons',
					esc_html__( 'Entypo', 'js_composer' ) => 'entypo',
					esc_html__( 'Linecons', 'js_composer' ) => 'linecons',
					esc_html__( 'Mono Social', 'js_composer' ) => 'monosocial',
					esc_html__( 'Material', 'js_composer' ) => 'material',
				),
				'admin_label' => true,
				'param_name' => 'type',
				'description' => esc_html__( 'Select icon library.', 'js_composer' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'js_composer' ),
				'param_name' => 'icon_fontawesome',
				'value' => 'fas fa-adjust',
				// default value to backend editor admin_label.
				'settings' => array(
					'emptyIcon' => false,
					// default true, display an "EMPTY" icon.
					'iconsPerPage' => 500,
					// default 100, how many icons per/page to display, we use (big number) to display all icons in single page.
				),
				'dependency' => array(
					'element' => 'type',
					'value' => 'fontawesome',
				),
				'description' => esc_html__( 'Select icon from library.', 'js_composer' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'js_composer' ),
				'param_name' => 'icon_openiconic',
				'value' => 'vc-oi vc-oi-dial',
				// default value to backend editor admin_label.
				'settings' => array(
					'emptyIcon' => false,
					// default true, display an "EMPTY" icon.
					'type' => 'openiconic',
					'iconsPerPage' => 4000,
					// default 100, how many icons per/page to display.
				),
				'dependency' => array(
					'element' => 'type',
					'value' => 'openiconic',
				),
				'description' => esc_html__( 'Select icon from library.', 'js_composer' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'js_composer' ),
				'param_name' => 'icon_typicons',
				'value' => 'typcn typcn-adjust-brightness',
				// default value to backend editor admin_label.
				'settings' => array(
					'emptyIcon' => false,
					// default true, display an "EMPTY" icon.
					'type' => 'typicons',
					'iconsPerPage' => 4000,
					// default 100, how many icons per/page to display.
				),
				'dependency' => array(
					'element' => 'type',
					'value' => 'typicons',
				),
				'description' => esc_html__( 'Select icon from library.', 'js_composer' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'js_composer' ),
				'param_name' => 'icon_entypo',
				'value' => 'entypo-icon entypo-icon-note',
				// default value to backend editor admin_label.
				'settings' => array(
					'emptyIcon' => false,
					// default true, display an "EMPTY" icon.
					'type' => 'entypo',
					'iconsPerPage' => 4000,
					// default 100, how many icons per/page to display.
				),
				'dependency' => array(
					'element' => 'type',
					'value' => 'entypo',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'js_composer' ),
				'param_name' => 'icon_linecons',
				'value' => 'vc_li vc_li-heart',
				// default value to backend editor admin_label.
				'settings' => array(
					'emptyIcon' => false,
					// default true, display an "EMPTY" icon.
					'type' => 'linecons',
					'iconsPerPage' => 4000,
					// default 100, how many icons per/page to display.
				),
				'dependency' => array(
					'element' => 'type',
					'value' => 'linecons',
				),
				'description' => esc_html__( 'Select icon from library.', 'js_composer' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'js_composer' ),
				'param_name' => 'icon_monosocial',
				'value' => 'vc-mono vc-mono-fivehundredpx',
				// default value to backend editor admin_label.
				'settings' => array(
					'emptyIcon' => false,
					// default true, display an "EMPTY" icon.
					'type' => 'monosocial',
					'iconsPerPage' => 4000,
					// default 100, how many icons per/page to display.
				),
				'dependency' => array(
					'element' => 'type',
					'value' => 'monosocial',
				),
				'description' => esc_html__( 'Select icon from library.', 'js_composer' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'js_composer' ),
				'param_name' => 'icon_material',
				'value' => 'vc-material vc-material-cake',
				// default value to backend editor admin_label.
				'settings' => array(
					'emptyIcon' => false,
					// default true, display an "EMPTY" icon.
					'type' => 'material',
					'iconsPerPage' => 4000,
					// default 100, how many icons per/page to display.
				),
				'dependency' => array(
					'element' => 'type',
					'value' => 'material',
				),
				'description' => esc_html__( 'Select icon from library.', 'js_composer' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon color', 'js_composer' ),
				'param_name' => 'color',
				'value' => array_merge( vc_get_shared( 'colors' ), array( esc_html__( 'Custom color', 'js_composer' ) => 'custom' ) ),
				'description' => esc_html__( 'Select icon color.', 'js_composer' ),
				'param_holder_class' => 'vc_colored-dropdown',
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__( 'Custom color', 'js_composer' ),
				'param_name' => 'custom_color',
				'description' => esc_html__( 'Select custom icon color.', 'js_composer' ),
				'dependency' => array(
					'element' => 'color',
					'value' => 'custom',
				),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Background shape', 'js_composer' ),
				'param_name' => 'background_style',
				'value' => array(
					esc_html__( 'None', 'js_composer' ) => '',
					esc_html__( 'Circle', 'js_composer' ) => 'rounded',
					esc_html__( 'Square', 'js_composer' ) => 'boxed',
					esc_html__( 'Rounded', 'js_composer' ) => 'rounded-less',
					esc_html__( 'Outline Circle', 'js_composer' ) => 'rounded-outline',
					esc_html__( 'Outline Square', 'js_composer' ) => 'boxed-outline',
					esc_html__( 'Outline Rounded', 'js_composer' ) => 'rounded-less-outline',
				),
				'description' => esc_html__( 'Select background shape and style for icon.', 'js_composer' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Background color', 'js_composer' ),
				'param_name' => 'background_color',
				'value' => array_merge( vc_get_shared( 'colors' ), array( esc_html__( 'Custom color', 'js_composer' ) => 'custom' ) ),
				'std' => 'grey',
				'description' => esc_html__( 'Select background color for icon.', 'js_composer' ),
				'param_holder_class' => 'vc_colored-dropdown',
				'dependency' => array(
					'element' => 'background_style',
					'not_empty' => true,
				),
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__( 'Custom background color', 'js_composer' ),
				'param_name' => 'custom_background_color',
				'description' => esc_html__( 'Select custom icon background color.', 'js_composer' ),
				'dependency' => array(
					'element' => 'background_color',
					'value' => 'custom',
				),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Size', 'js_composer' ),
				'param_name' => 'size',
				'value' => array_merge( vc_get_shared( 'sizes' ), array( 'Extra Large' => 'xl' ) ),
				'std' => 'md',
				'description' => esc_html__( 'Icon size.', 'js_composer' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon alignment', 'js_composer' ),
				'param_name' => 'align',
				'value' => array(
					esc_html__( 'Left', 'js_composer' ) => 'left',
					esc_html__( 'Right', 'js_composer' ) => 'right',
					esc_html__( 'Center', 'js_composer' ) => 'center',
				),
				'description' => esc_html__( 'Select icon alignment.', 'js_composer' ),
			),
			array(
				'type' => 'vc_link',
				'heading' => esc_html__( 'URL (Link)', 'js_composer' ),
				'param_name' => 'link',
				'description' => esc_html__( 'Add link to icon.', 'js_composer' ),
			),
			vc_map_add_css_animation(),
			array(
				'type' => 'el_id',
				'heading' => esc_html__( 'Element ID', 'js_composer' ),
				'param_name' => 'el_id',
				'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Extra class name', 'js_composer' ),
				'param_name' => 'el_class',
				'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
			),
			array(
				'type' => 'css_editor',
				'heading' => esc_html__( 'CSS box', 'js_composer' ),
				'param_name' => 'css',
				'group' => esc_html__( 'Design Options', 'js_composer' ),
				'value' => array(
					'margin-bottom' => '35px',
				),
			),
		),
		'js_view' => 'VcIconElementView_Backend',
	);
}
shortcode-vc-icon.php                                                                                                                                                                                                                                          313           1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_icon] shortcode of 'Icon' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

require_once 'vc-icon-element.php';

return vc_icon_element_params();
shortcode-vc-posts-slider.php                                                                                                                                                                                                                                  7263          1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_posts_slider] shortcode of 'Posts Slider' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

return array(
	'name' => esc_html__( 'Posts Slider', 'js_composer' ),
	'base' => 'vc_posts_slider',
	'icon' => 'icon-wpb-slideshow',
	'element_default_class' => 'wpb_content_element',
	'category' => esc_html__( 'Content', 'js_composer' ),
	'description' => esc_html__( 'Slider with WP Posts', 'js_composer' ),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Widget title', 'js_composer' ),
			'param_name' => 'title',
			'description' => esc_html__( 'Enter text used as widget title (Note: located above content element).', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Slider type', 'js_composer' ),
			'param_name' => 'type',
			'admin_label' => true,
			'value' => array(
				esc_html__( 'Flex slider fade', 'js_composer' ) => 'flexslider_fade',
				esc_html__( 'Flex slider slide', 'js_composer' ) => 'flexslider_slide',
				esc_html__( 'Nivo slider', 'js_composer' ) => 'nivo',
			),
			'description' => esc_html__( 'Select slider type.', 'js_composer' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Slider count', 'js_composer' ),
			'param_name' => 'count',
			'value' => 3,
			'description' => esc_html__( 'Enter number of slides to display (Note: Enter "All" to display all slides).', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Auto rotate', 'js_composer' ),
			'param_name' => 'interval',
			'value' => array(
				3,
				5,
				10,
				15,
				esc_html__( 'Disable', 'js_composer' ) => 0,
			),
			'description' => esc_html__( 'Auto rotate slides each X seconds.', 'js_composer' ),
		),
		array(
			'type' => 'posttypes',
			'heading' => esc_html__( 'Post types', 'js_composer' ),
			'param_name' => 'posttypes',
			'description' => esc_html__( 'Select source for slider.', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Description', 'js_composer' ),
			'param_name' => 'slides_content',
			'value' => array(
				esc_html__( 'No description', 'js_composer' ) => '',
				esc_html__( 'Teaser (Excerpt)', 'js_composer' ) => 'teaser',
			),
			'description' => esc_html__( 'Select source to use for description (Note: some sliders do not support it).', 'js_composer' ),
			'dependency' => array(
				'element' => 'type',
				'value' => array(
					'flexslider_fade',
					'flexslider_slide',
				),
			),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Output post title?', 'js_composer' ),
			'param_name' => 'slides_title',
			'description' => esc_html__( 'If selected, title will be printed before the teaser text.', 'js_composer' ),
			'value' => array( esc_html__( 'Yes', 'js_composer' ) => true ),
			'dependency' => array(
				'element' => 'slides_content',
				'value' => array( 'teaser' ),
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Link', 'js_composer' ),
			'param_name' => 'link',
			'value' => array(
				esc_html__( 'Link to post', 'js_composer' ) => 'link_post',
				esc_html__( 'Link to bigger image', 'js_composer' ) => 'link_image',
				esc_html__( 'Open custom links', 'js_composer' ) => 'custom_link',
				esc_html__( 'No link', 'js_composer' ) => 'link_no',
			),
			'description' => esc_html__( 'Link type.', 'js_composer' ),
		),
		array(
			'type' => 'exploded_textarea_safe',
			'heading' => esc_html__( 'Custom links', 'js_composer' ),
			'param_name' => 'custom_links',
			'value' => site_url() . '/',
			'dependency' => array(
				'element' => 'link',
				'value' => 'custom_link',
			),
			'description' => esc_html__( 'Enter links for each slide here. Divide links with linebreaks (Enter).', 'js_composer' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Thumbnail size', 'js_composer' ),
			'param_name' => 'thumb_size',
			'value' => 'medium',
			'description' => esc_html__( 'Enter thumbnail size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height) . ', 'js_composer' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Post/Page IDs', 'js_composer' ),
			'param_name' => 'posts_in',
			'description' => esc_html__( 'Enter page/posts IDs to display only those records (Note: separate values by commas (,)). Use this field in conjunction with "Post types" field.', 'js_composer' ),
		),
		array(
			'type' => 'exploded_textarea_safe',
			'heading' => esc_html__( 'Categories', 'js_composer' ),
			'param_name' => 'categories',
			'description' => esc_html__( 'Enter categories by names to narrow output (Note: only listed categories will be displayed, divide categories with linebreak (Enter)).', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Order by', 'js_composer' ),
			'param_name' => 'orderby',
			'value' => array(
				'',
				esc_html__( 'Date', 'js_composer' ) => 'date',
				esc_html__( 'ID', 'js_composer' ) => 'ID',
				esc_html__( 'Author', 'js_composer' ) => 'author',
				esc_html__( 'Title', 'js_composer' ) => 'title',
				esc_html__( 'Modified', 'js_composer' ) => 'modified',
				esc_html__( 'Random', 'js_composer' ) => 'rand',
				esc_html__( 'Comment count', 'js_composer' ) => 'comment_count',
				esc_html__( 'Menu order', 'js_composer' ) => 'menu_order',
			),
			'description' => sprintf( esc_html__( 'Select how to sort retrieved posts. More at %s.', 'js_composer' ), '<a href="https://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Sort order', 'js_composer' ),
			'param_name' => 'order',
			'value' => array(
				esc_html__( 'Descending', 'js_composer' ) => 'DESC',
				esc_html__( 'Ascending', 'js_composer' ) => 'ASC',
			),
			'description' => sprintf( esc_html__( 'Select ascending or descending order. More at %s.', 'js_composer' ), '<a href="https://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
		),
		array(
			'type' => 'el_id',
			'heading' => esc_html__( 'Element ID', 'js_composer' ),
			'param_name' => 'el_id',
			'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'js_composer' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'js_composer' ),
			'value' => array(
				'margin-bottom' => '35px',
			),
		),
	),
);
shortcode-vc-zigzag.php                                                                                                                                                                                                                                        3484          1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_zigzag] shortcode of 'ZigZag Separator' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

return array(
	'name' => esc_html__( 'ZigZag Separator', 'js_composer' ),
	'base' => 'vc_zigzag',
	'icon' => 'vc_icon-vc-zigzag',
	'category' => esc_html__( 'Content', 'js_composer' ),
	'description' => esc_html__( 'Horizontal zigzag separator line', 'js_composer' ),
	'params' => array(
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Color', 'js_composer' ),
			'param_name' => 'color',
			'value' => array_merge( vc_get_shared( 'colors' ), array( esc_html__( 'Custom color', 'js_composer' ) => 'custom' ) ),
			'std' => 'grey',
			'description' => esc_html__( 'Select color of separator.', 'js_composer' ),
			'param_holder_class' => 'vc_colored-dropdown',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Color', 'js_composer' ),
			'param_name' => 'custom_color',
			'description' => esc_html__( 'Select color for your element.', 'js_composer' ),
			'dependency' => array(
				'element' => 'color',
				'value' => array( 'custom' ),
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Alignment', 'js_composer' ),
			'param_name' => 'align',
			'value' => array(
				esc_html__( 'Center', 'js_composer' ) => 'center',
				esc_html__( 'Left', 'js_composer' ) => 'left',
				esc_html__( 'Right', 'js_composer' ) => 'right',
			),
			'description' => esc_html__( 'Select separator alignment.', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Element width', 'js_composer' ),
			'param_name' => 'el_width',
			'value' => array(
				'100%' => '100',
				'90%' => '90',
				'80%' => '80',
				'70%' => '70',
				'60%' => '60',
				'50%' => '50',
				'40%' => '40',
				'30%' => '30',
				'20%' => '20',
				'10%' => '10',
			),
			'description' => esc_html__( 'Select separator width (percentage).', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Border width', 'js_composer' ),
			'param_name' => 'el_border_width',
			'std' => '12',
			'value' => array(
				esc_html__( 'Extra small', 'js_composer' ) => '8',
				esc_html__( 'Small', 'js_composer' ) => '10',
				esc_html__( 'Medium', 'js_composer' ) => '12',
				esc_html__( 'Large', 'js_composer' ) => '15',
				esc_html__( 'Extra large', 'js_composer' ) => '20',
			),
			'description' => esc_html__( 'Select separator border width.', 'js_composer' ),
		),
		vc_map_add_css_animation(),
		array(
			'type' => 'el_id',
			'heading' => esc_html__( 'Element ID', 'js_composer' ),
			'param_name' => 'el_id',
			'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'js_composer' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'js_composer' ),
		),
	),
);
shortcode-vc-single-image.php                                                                                                                                                                                                                                  8111          1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_single_image] shortcode of 'Single Image' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

return array(
	'name' => esc_html__( 'Single Image', 'js_composer' ),
	'base' => 'vc_single_image',
	'icon' => 'icon-wpb-single-image',
	'element_default_class' => 'wpb_content_element',
	'category' => esc_html__( 'Content', 'js_composer' ),
	'description' => esc_html__( 'Simple image with CSS animation', 'js_composer' ),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Widget title', 'js_composer' ),
			'param_name' => 'title',
			'description' => esc_html__( 'Enter text used as widget title (Note: located above content element).', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Image source', 'js_composer' ),
			'param_name' => 'source',
			'value' => array(
				esc_html__( 'Media library', 'js_composer' ) => 'media_library',
				esc_html__( 'External link', 'js_composer' ) => 'external_link',
				esc_html__( 'Featured Image', 'js_composer' ) => 'featured_image',
			),
			'std' => 'media_library',
			'description' => esc_html__( 'Select image source.', 'js_composer' ),
		),
		array(
			'type' => 'attach_image',
			'heading' => esc_html__( 'Image', 'js_composer' ),
			'param_name' => 'image',
			'value' => '',
			'description' => esc_html__( 'Select image from media library.', 'js_composer' ),
			'dependency' => array(
				'element' => 'source',
				'value' => 'media_library',
			),
			'admin_label' => true,
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'External link', 'js_composer' ),
			'param_name' => 'custom_src',
			'description' => esc_html__( 'Select external link.', 'js_composer' ),
			'dependency' => array(
				'element' => 'source',
				'value' => 'external_link',
			),
			'admin_label' => true,
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Image size', 'js_composer' ),
			'param_name' => 'img_size',
			'value' => 'thumbnail',
			'description' => esc_html__( 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height)).', 'js_composer' ),
			'dependency' => array(
				'element' => 'source',
				'value' => array(
					'media_library',
					'featured_image',
				),
			),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Image size', 'js_composer' ),
			'param_name' => 'external_img_size',
			'value' => '',
			'description' => esc_html__( 'Enter image size in pixels. Example: 200x100 (Width x Height).', 'js_composer' ),
			'dependency' => array(
				'element' => 'source',
				'value' => 'external_link',
			),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Caption', 'js_composer' ),
			'param_name' => 'caption',
			'description' => esc_html__( 'Enter text for image caption.', 'js_composer' ),
			'dependency' => array(
				'element' => 'source',
				'value' => 'external_link',
			),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Add caption?', 'js_composer' ),
			'param_name' => 'add_caption',
			'description' => esc_html__( 'Add image caption.', 'js_composer' ),
			'value' => array( esc_html__( 'Yes', 'js_composer' ) => 'yes' ),
			'dependency' => array(
				'element' => 'source',
				'value' => array(
					'media_library',
					'featured_image',
				),
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Image alignment', 'js_composer' ),
			'param_name' => 'alignment',
			'value' => array(
				esc_html__( 'Left', 'js_composer' ) => 'left',
				esc_html__( 'Right', 'js_composer' ) => 'right',
				esc_html__( 'Center', 'js_composer' ) => 'center',
			),
			'description' => esc_html__( 'Select image alignment.', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Image style', 'js_composer' ),
			'param_name' => 'style',
			'value' => vc_get_shared( 'single image styles' ),
			'description' => esc_html__( 'Select image display style.', 'js_composer' ),
			'dependency' => array(
				'element' => 'source',
				'value' => array(
					'media_library',
					'featured_image',
				),
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Image style', 'js_composer' ),
			'param_name' => 'external_style',
			'value' => vc_get_shared( 'single image external styles' ),
			'description' => esc_html__( 'Select image display style.', 'js_composer' ),
			'dependency' => array(
				'element' => 'source',
				'value' => 'external_link',
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Border color', 'js_composer' ),
			'param_name' => 'border_color',
			'value' => vc_get_shared( 'colors' ),
			'std' => 'grey',
			'dependency' => array(
				'element' => 'style',
				'value' => array(
					'vc_box_border',
					'vc_box_border_circle',
					'vc_box_outline',
					'vc_box_outline_circle',
					'vc_box_border_circle_2',
					'vc_box_outline_circle_2',
				),
			),
			'description' => esc_html__( 'Border color.', 'js_composer' ),
			'param_holder_class' => 'vc_colored-dropdown',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Border color', 'js_composer' ),
			'param_name' => 'external_border_color',
			'value' => vc_get_shared( 'colors' ),
			'std' => 'grey',
			'dependency' => array(
				'element' => 'external_style',
				'value' => array(
					'vc_box_border',
					'vc_box_border_circle',
					'vc_box_outline',
					'vc_box_outline_circle',
				),
			),
			'description' => esc_html__( 'Border color.', 'js_composer' ),
			'param_holder_class' => 'vc_colored-dropdown',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'On click action', 'js_composer' ),
			'param_name' => 'onclick',
			'value' => array(
				esc_html__( 'None', 'js_composer' ) => '',
				esc_html__( 'Link to large image', 'js_composer' ) => 'img_link_large',
				esc_html__( 'Open Lightbox', 'js_composer' ) => 'link_image',
				esc_html__( 'Open custom link', 'js_composer' ) => 'custom_link',
				esc_html__( 'Zoom', 'js_composer' ) => 'zoom',
			),
			'description' => esc_html__( 'Select action for click action.', 'js_composer' ),
			'std' => '',
		),
		array(
			'type' => 'href',
			'heading' => esc_html__( 'Image link', 'js_composer' ),
			'param_name' => 'link',
			'description' => esc_html__( 'Enter URL if you want this image to have a link (Note: parameters like "mailto:" are also accepted).', 'js_composer' ),
			'dependency' => array(
				'element' => 'onclick',
				'value' => 'custom_link',
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Link Target', 'js_composer' ),
			'param_name' => 'img_link_target',
			'value' => vc_target_param_list(),
			'dependency' => array(
				'element' => 'onclick',
				'value' => array(
					'custom_link',
					'img_link_large',
				),
			),
		),
		vc_map_add_css_animation(),
		array(
			'type' => 'el_id',
			'heading' => esc_html__( 'Element ID', 'js_composer' ),
			'param_name' => 'el_id',
			'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'js_composer' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'js_composer' ),
			'value' => array(
				'margin-bottom' => '35px',
			),
		),
		// backward compatibility. since 4.6.
		array(
			'type' => 'hidden',
			'param_name' => 'img_link_large',
		),
	),
);
shortcode-vc-images-carousel.php                                                                                                                                                                                                                               6113          1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_images_carousel] shortcode of 'Image Carousel' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

return array(
	'name' => esc_html__( 'Image Carousel', 'js_composer' ),
	'base' => 'vc_images_carousel',
	'icon' => 'icon-wpb-images-carousel',
	'element_default_class' => 'wpb_content_element',
	'category' => esc_html__( 'Content', 'js_composer' ),
	'description' => esc_html__( 'Animated carousel with images', 'js_composer' ),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Widget title', 'js_composer' ),
			'param_name' => 'title',
			'description' => esc_html__( 'Enter text used as widget title (Note: located above content element).', 'js_composer' ),
		),
		array(
			'type' => 'attach_images',
			'heading' => esc_html__( 'Images', 'js_composer' ),
			'param_name' => 'images',
			'value' => '',
			'description' => esc_html__( 'Select images from media library.', 'js_composer' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Carousel size', 'js_composer' ),
			'param_name' => 'img_size',
			'value' => 'thumbnail',
			'description' => esc_html__( 'Enter image size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size. If used slides per view, this will be used to define carousel wrapper size.', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'On click action', 'js_composer' ),
			'param_name' => 'onclick',
			'value' => array(
				esc_html__( 'Open Lightbox', 'js_composer' ) => 'link_image',
				esc_html__( 'None', 'js_composer' ) => 'link_no',
				esc_html__( 'Open custom links', 'js_composer' ) => 'custom_link',
			),
			'description' => esc_html__( 'Select action for click event.', 'js_composer' ),
		),
		array(
			'type' => 'exploded_textarea_safe',
			'heading' => esc_html__( 'Custom links', 'js_composer' ),
			'param_name' => 'custom_links',
			'description' => esc_html__( 'Enter links for each slide (Note: divide links with linebreaks (Enter)).', 'js_composer' ),
			'dependency' => array(
				'element' => 'onclick',
				'value' => array( 'custom_link' ),
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Custom link target', 'js_composer' ),
			'param_name' => 'custom_links_target',
			'description' => esc_html__( 'Select how to open custom links.', 'js_composer' ),
			'dependency' => array(
				'element' => 'onclick',
				'value' => array( 'custom_link' ),
			),
			'value' => vc_target_param_list(),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Slider orientation', 'js_composer' ),
			'param_name' => 'mode',
			'value' => array(
				esc_html__( 'Horizontal', 'js_composer' ) => 'horizontal',
				esc_html__( 'Vertical', 'js_composer' ) => 'vertical',
			),
			'description' => esc_html__( 'Select slider position (Note: this affects swiping orientation).', 'js_composer' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Slider speed', 'js_composer' ),
			'param_name' => 'speed',
			'value' => '5000',
			'description' => esc_html__( 'Duration of animation between slides (in ms).', 'js_composer' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Slides per view', 'js_composer' ),
			'param_name' => 'slides_per_view',
			'value' => '1',
			'description' => esc_html__( 'Enter number of slides to display at the same time.', 'js_composer' ),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Slider autoplay', 'js_composer' ),
			'param_name' => 'autoplay',
			'description' => esc_html__( 'Enable autoplay mode.', 'js_composer' ),
			'value' => array( esc_html__( 'Yes', 'js_composer' ) => 'yes' ),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Hide pagination control', 'js_composer' ),
			'param_name' => 'hide_pagination_control',
			'description' => esc_html__( 'If checked, pagination controls will be hidden.', 'js_composer' ),
			'value' => array( esc_html__( 'Yes', 'js_composer' ) => 'yes' ),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Hide prev/next buttons', 'js_composer' ),
			'param_name' => 'hide_prev_next_buttons',
			'description' => esc_html__( 'If checked, prev/next buttons will be hidden.', 'js_composer' ),
			'value' => array( esc_html__( 'Yes', 'js_composer' ) => 'yes' ),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Partial view', 'js_composer' ),
			'param_name' => 'partial_view',
			'description' => esc_html__( 'If checked, part of the next slide will be visible.', 'js_composer' ),
			'value' => array( esc_html__( 'Yes', 'js_composer' ) => 'yes' ),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Slider loop', 'js_composer' ),
			'param_name' => 'wrap',
			'description' => esc_html__( 'Enable slider loop mode.', 'js_composer' ),
			'value' => array( esc_html__( 'Yes', 'js_composer' ) => 'yes' ),
		),
		vc_map_add_css_animation(),
		array(
			'type' => 'el_id',
			'heading' => esc_html__( 'Element ID', 'js_composer' ),
			'param_name' => 'el_id',
			'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'js_composer' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'js_composer' ),
			'value' => array(
				'margin-bottom' => '35px',
			),
		),
	),
);
shortcode-vc-line-chart.php                                                                                                                                                                                                                                    5480          1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_line_chart] shortcode of 'Line Chart' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

return array(
	'name' => esc_html__( 'Line Chart', 'js_composer' ),
	'base' => 'vc_line_chart',
	'class' => '',
	'icon' => 'icon-wpb-vc-line-chart',
	'element_default_class' => 'wpb_content_element',
	'category' => esc_html__( 'Content', 'js_composer' ),
	'description' => esc_html__( 'Line and Bar charts', 'js_composer' ),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Widget title', 'js_composer' ),
			'param_name' => 'title',
			'description' => esc_html__( 'Enter text used as widget title (Note: located above content element).', 'js_composer' ),
			'admin_label' => true,
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Design', 'js_composer' ),
			'param_name' => 'type',
			'value' => array(
				esc_html__( 'Line', 'js_composer' ) => 'line',
				esc_html__( 'Bar', 'js_composer' ) => 'bar',
			),
			'std' => 'bar',
			'description' => esc_html__( 'Select type of chart.', 'js_composer' ),
			'admin_label' => true,
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Style', 'js_composer' ),
			'description' => esc_html__( 'Select chart color style.', 'js_composer' ),
			'param_name' => 'style',
			'value' => array(
				esc_html__( 'Flat', 'js_composer' ) => 'flat',
				esc_html__( 'Modern', 'js_composer' ) => 'modern',
				esc_html__( 'Custom', 'js_composer' ) => 'custom',
			),
			'dependency' => array(
				'callback' => 'vcChartCustomColorDependency',
			),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Show legend?', 'js_composer' ),
			'param_name' => 'legend',
			'description' => esc_html__( 'If checked, chart will have legend.', 'js_composer' ),
			'value' => array( esc_html__( 'Yes', 'js_composer' ) => 'yes' ),
			'std' => 'yes',
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Show hover values?', 'js_composer' ),
			'param_name' => 'tooltips',
			'description' => esc_html__( 'If checked, chart will show values on hover.', 'js_composer' ),
			'value' => array( esc_html__( 'Yes', 'js_composer' ) => 'yes' ),
			'std' => 'yes',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'X-axis values', 'js_composer' ),
			'param_name' => 'x_values',
			'description' => esc_html__( 'Enter values for axis (Note: separate values with ";").', 'js_composer' ),
			'value' => 'JAN; FEB; MAR; APR; MAY; JUN; JUL; AUG',
		),
		array(
			'type' => 'param_group',
			'heading' => esc_html__( 'Values', 'js_composer' ),
			'param_name' => 'values',
			'value' => rawurlencode( wp_json_encode( array(
				array(
					'title' => esc_html__( 'One', 'js_composer' ),
					'y_values' => '10; 15; 20; 25; 27; 25; 23; 25',
					'color' => 'blue',
				),
				array(
					'title' => esc_html__( 'Two', 'js_composer' ),
					'y_values' => '25; 18; 16; 17; 20; 25; 30; 35',
					'color' => 'pink',
				),
			) ) ),
			'params' => array(
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Title', 'js_composer' ),
					'param_name' => 'title',
					'description' => esc_html__( 'Enter title for chart dataset.', 'js_composer' ),
					'admin_label' => true,
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Y-axis values', 'js_composer' ),
					'param_name' => 'y_values',
					'description' => esc_html__( 'Enter values for axis (Note: separate values with ";").', 'js_composer' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Color', 'js_composer' ),
					'param_name' => 'color',
					'value' => vc_get_shared( 'colors-dashed' ),
					'description' => esc_html__( 'Select chart color.', 'js_composer' ),
					'param_holder_class' => 'vc_colored-dropdown',
				),
				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( 'Custom color', 'js_composer' ),
					'param_name' => 'custom_color',
					'description' => esc_html__( 'Select custom chart color.', 'js_composer' ),
				),
			),
			'callbacks' => array(
				'after_add' => 'vcChartParamAfterAddCallback',
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Animation', 'js_composer' ),
			'description' => esc_html__( 'Select animation style.', 'js_composer' ),
			'param_name' => 'animation',
			'value' => vc_get_shared( 'animation styles' ),
			'std' => 'easeInOutCubic',
		),
		vc_map_add_css_animation(),
		array(
			'type' => 'el_id',
			'heading' => esc_html__( 'Element ID', 'js_composer' ),
			'param_name' => 'el_id',
			'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'js_composer' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'js_composer' ),
			'value' => array(
				'margin-bottom' => '35px',
			),
		),
	),
);
shortcode-vc-video.php                                                                                                                                                                                                                                         3451          1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_video] shortcode of 'Video Player' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

return array(
	'name' => esc_html__( 'Video Player', 'js_composer' ),
	'base' => 'vc_video',
	'icon' => 'icon-wpb-film-youtube',
	'element_default_class' => 'wpb_content_element',
	'category' => esc_html__( 'Content', 'js_composer' ),
	'description' => esc_html__( 'Embed YouTube/Vimeo player', 'js_composer' ),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Widget title', 'js_composer' ),
			'param_name' => 'title',
			'description' => esc_html__( 'Enter text used as widget title (Note: located above content element).', 'js_composer' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Video link', 'js_composer' ),
			'param_name' => 'link',
			'value' => 'https://vimeo.com/channels/staffpicks/181907337',
			'admin_label' => true,
			'description' => sprintf( esc_html__( 'Enter link to video (Note: read more about available formats at WordPress %1$scodex page%2$s).', 'js_composer' ), '<a href="https://codex.wordpress.org/Embeds#Okay.2C_So_What_Sites_Can_I_Embed_From.3F" target="_blank">', '</a>' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Video width', 'js_composer' ),
			'param_name' => 'el_width',
			'value' => array(
				'100%' => '100',
				'90%' => '90',
				'80%' => '80',
				'70%' => '70',
				'60%' => '60',
				'50%' => '50',
				'40%' => '40',
				'30%' => '30',
				'20%' => '20',
				'10%' => '10',
			),
			'description' => esc_html__( 'Select video width (percentage).', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Video aspect ratio', 'js_composer' ),
			'param_name' => 'el_aspect',
			'value' => array(
				'16:9' => '169',
				'4:3' => '43',
				'2.35:1' => '235',
				'9:16' => '916',
				'3:4' => '34',
				'1:2.35' => '1235',
			),
			'description' => esc_html__( 'Select video aspect ratio.', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Alignment', 'js_composer' ),
			'param_name' => 'align',
			'description' => esc_html__( 'Select video alignment.', 'js_composer' ),
			'value' => array(
				esc_html__( 'Left', 'js_composer' ) => 'left',
				esc_html__( 'Right', 'js_composer' ) => 'right',
				esc_html__( 'Center', 'js_composer' ) => 'center',
			),
		),
		vc_map_add_css_animation(),
		array(
			'type' => 'el_id',
			'heading' => esc_html__( 'Element ID', 'js_composer' ),
			'param_name' => 'el_id',
			'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'js_composer' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'js_composer' ),
			'value' => array(
				'margin-bottom' => '35px',
			),
		),
	),
);
shortcode-vc-pie.php                                                                                                                                                                                                                                           3347          1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_pie] shortcode of 'Pie Chart' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

return array(
	'name' => esc_html__( 'Pie Chart', 'js_composer' ),
	'base' => 'vc_pie',
	'class' => '',
	'icon' => 'icon-wpb-vc_pie',
	'element_default_class' => 'wpb_content_element',
	'category' => esc_html__( 'Content', 'js_composer' ),
	'description' => esc_html__( 'Animated pie chart', 'js_composer' ),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Widget title', 'js_composer' ),
			'param_name' => 'title',
			'description' => esc_html__( 'Enter text used as widget title (Note: located above content element).', 'js_composer' ),
			'admin_label' => true,
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Value', 'js_composer' ),
			'param_name' => 'value',
			'description' => esc_html__( 'Enter value for graph (Note: choose range from 0 to 100).', 'js_composer' ),
			'value' => '50',
			'admin_label' => true,
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Label value', 'js_composer' ),
			'param_name' => 'label_value',
			'description' => esc_html__( 'Enter label for pie chart (Note: leaving empty will set value from "Value" field).', 'js_composer' ),
			'value' => '',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Units', 'js_composer' ),
			'param_name' => 'units',
			'description' => esc_html__( 'Enter measurement units (Example: %, px, points, etc. Note: graph value and units will be appended to graph title).', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Color', 'js_composer' ),
			'param_name' => 'color',
			'value' => vc_get_shared( 'colors-dashed' ) + array( esc_html__( 'Custom', 'js_composer' ) => 'custom' ),
			'description' => esc_html__( 'Select pie chart color.', 'js_composer' ),
			'admin_label' => true,
			'param_holder_class' => 'vc_colored-dropdown',
			'std' => 'grey',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom color', 'js_composer' ),
			'param_name' => 'custom_color',
			'description' => esc_html__( 'Select custom color.', 'js_composer' ),
			'dependency' => array(
				'element' => 'color',
				'value' => array( 'custom' ),
			),
		),
		vc_map_add_css_animation(),
		array(
			'type' => 'el_id',
			'heading' => esc_html__( 'Element ID', 'js_composer' ),
			'param_name' => 'el_id',
			'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'js_composer' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'js_composer' ),
			'value' => array(
				'margin-bottom' => '35px',
			),
		),
	),
);
shortcode-vc-gmaps.php                                                                                                                                                                                                                                         2944          1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_gmaps] shortcode of 'Google Maps' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

return array(
	'name' => esc_html__( 'Google Maps', 'js_composer' ),
	'base' => 'vc_gmaps',
	'icon' => 'icon-wpb-map-pin',
	'element_default_class' => 'wpb_content_element',
	'category' => esc_html__( 'Content', 'js_composer' ),
	'description' => esc_html__( 'Map block', 'js_composer' ),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Widget title', 'js_composer' ),
			'param_name' => 'title',
			'description' => esc_html__( 'Enter text used as widget title (Note: located above content element).', 'js_composer' ),
		),
		array(
			'type' => 'textarea_safe',
			'heading' => esc_html__( 'Map embed iframe', 'js_composer' ),
			'param_name' => 'link',
			'value' => '<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d6304.829986131271!2d-122.4746968033092!3d37.80374752160443!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x808586e6302615a1%3A0x86bd130251757c00!2sStorey+Ave%2C+San+Francisco%2C+CA+94129!5e0!3m2!1sen!2sus!4v1435826432051" width="600" height="450" frameborder="0" style="border:0" allowfullscreen></iframe>',
			'description' => sprintf( esc_html__( 'Visit %s to create your map (Step by step: 1) Find location 2) Click the cog symbol in the lower right corner and select "Share or embed map" 3) On modal window select "Embed map" 4) Copy iframe code and paste it).' ), '<a href="https://www.google.com/maps" target="_blank">' . esc_html__( 'Google maps', 'js_composer' ) . '</a>' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Map height', 'js_composer' ),
			'param_name' => 'size',
			'value' => 'standard',
			'admin_label' => true,
			'description' => esc_html__( 'Enter map height (in pixels or leave empty for responsive map).', 'js_composer' ),
		),
		vc_map_add_css_animation(),
		array(
			'type' => 'el_id',
			'heading' => esc_html__( 'Element ID', 'js_composer' ),
			'param_name' => 'el_id',
			'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'js_composer' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'js_composer' ),
			'value' => array(
				'margin-bottom' => '35px',
			),
		),
	),
);
shortcode-vc-text-separator.php                                                                                                                                                                                                                                5282          1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_text_separator] shortcode of 'Separator with Text' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

require_once 'vc-icon-element.php';
$icon_params = vc_icon_element_params();

$icons_params = vc_map_integrate_shortcode( $icon_params, 'i_', esc_html__( 'Icon', 'js_composer' ), array(
	'exclude' => array(
		'align',
		'css',
		'el_class',
		'el_id',
		'link',
		'css_animation',
	),
	// we need only type, icon_fontawesome, icon_blabla..., NOT color and etc.
), array(
	'element' => 'add_icon',
	'value' => 'true',
) );

// populate integrated vc_icons params.
if ( is_array( $icons_params ) && ! empty( $icons_params ) ) {
	foreach ( $icons_params as $key => $param ) {
		if ( is_array( $param ) && ! empty( $param ) ) {
			if ( isset( $param['admin_label'] ) ) {
				// remove admin label.
				unset( $icons_params[ $key ]['admin_label'] );
			}
		}
	}
}

return array(
	'name' => esc_html__( 'Separator with Text', 'js_composer' ),
	'base' => 'vc_text_separator',
	'icon' => 'icon-wpb-ui-separator-label',
	'element_default_class' => 'wpb_content_element',
	'category' => esc_html__( 'Content', 'js_composer' ),
	'description' => esc_html__( 'Horizontal separator line with heading', 'js_composer' ),
	'params' => array_merge( array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Title', 'js_composer' ),
			'param_name' => 'title',
			'holder' => 'div',
			'value' => esc_html__( 'Title', 'js_composer' ),
			'description' => esc_html__( 'Add text to separator.', 'js_composer' ),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Add icon?', 'js_composer' ),
			'param_name' => 'add_icon',
		),
	), $icons_params, array(
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Title position', 'js_composer' ),
			'param_name' => 'title_align',
			'value' => array(
				esc_html__( 'Center', 'js_composer' ) => 'separator_align_center',
				esc_html__( 'Left', 'js_composer' ) => 'separator_align_left',
				esc_html__( 'Right', 'js_composer' ) => 'separator_align_right',
			),
			'description' => esc_html__( 'Select title location.', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Separator alignment', 'js_composer' ),
			'param_name' => 'align',
			'value' => array(
				esc_html__( 'Center', 'js_composer' ) => 'align_center',
				esc_html__( 'Left', 'js_composer' ) => 'align_left',
				esc_html__( 'Right', 'js_composer' ) => 'align_right',
			),
			'description' => esc_html__( 'Select separator alignment.', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Color', 'js_composer' ),
			'param_name' => 'color',
			'value' => array_merge( vc_get_shared( 'colors' ), array( esc_html__( 'Custom color', 'js_composer' ) => 'custom' ) ),
			'std' => 'grey',
			'description' => esc_html__( 'Select color of separator.', 'js_composer' ),
			'param_holder_class' => 'vc_colored-dropdown',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Color', 'js_composer' ),
			'param_name' => 'accent_color',
			'description' => esc_html__( 'Custom separator color for your element.', 'js_composer' ),
			'dependency' => array(
				'element' => 'color',
				'value' => array( 'custom' ),
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Style', 'js_composer' ),
			'param_name' => 'style',
			'value' => vc_get_shared( 'separator styles' ),
			'description' => esc_html__( 'Separator display style.', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Border width', 'js_composer' ),
			'param_name' => 'border_width',
			'value' => vc_get_shared( 'separator border widths' ),
			'description' => esc_html__( 'Select border width (pixels).', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Element width', 'js_composer' ),
			'param_name' => 'el_width',
			'value' => vc_get_shared( 'separator widths' ),
			'description' => esc_html__( 'Separator element width in percents.', 'js_composer' ),
		),
		vc_map_add_css_animation(),
		array(
			'type' => 'el_id',
			'heading' => esc_html__( 'Element ID', 'js_composer' ),
			'param_name' => 'el_id',
			'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
		),
		array(
			'type' => 'hidden',
			'param_name' => 'layout',
			'value' => 'separator_with_text',
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'js_composer' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'js_composer' ),
			'value' => array(
				'margin-bottom' => '35px',
			),
		),
	) ),
	'js_view' => 'VcTextSeparatorView',
);
shortcode-vc-round-chart.php                                                                                                                                                                                                                                   7528          1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_round_chart] shortcode of 'Round Chart' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

return array(
	'name' => esc_html__( 'Round Chart', 'js_composer' ),
	'base' => 'vc_round_chart',
	'class' => '',
	'icon' => 'icon-wpb-vc-round-chart',
	'element_default_class' => 'wpb_content_element',
	'category' => esc_html__( 'Content', 'js_composer' ),
	'description' => esc_html__( 'Pie and Doughnut charts', 'js_composer' ),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Widget title', 'js_composer' ),
			'param_name' => 'title',
			'description' => esc_html__( 'Enter text used as widget title (Note: located above content element).', 'js_composer' ),
			'admin_label' => true,
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Design', 'js_composer' ),
			'param_name' => 'type',
			'value' => array(
				esc_html__( 'Pie', 'js_composer' ) => 'pie',
				esc_html__( 'Doughnut', 'js_composer' ) => 'doughnut',
			),
			'description' => esc_html__( 'Select type of chart.', 'js_composer' ),
			'admin_label' => true,
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Style', 'js_composer' ),
			'description' => esc_html__( 'Select chart color style.', 'js_composer' ),
			'param_name' => 'style',
			'value' => array(
				esc_html__( 'Flat', 'js_composer' ) => 'flat',
				esc_html__( 'Modern', 'js_composer' ) => 'modern',
				esc_html__( 'Custom', 'js_composer' ) => 'custom',
			),
			'dependency' => array(
				'callback' => 'vcChartCustomColorDependency',
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Gap', 'js_composer' ),
			'param_name' => 'stroke_width',
			'value' => array(
				0 => 0,
				1 => 1,
				2 => 2,
				5 => 5,
			),
			'description' => esc_html__( 'Select gap size.', 'js_composer' ),
			'std' => 2,
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Outline color', 'js_composer' ),
			'param_name' => 'stroke_color',
			'value' => vc_get_shared( 'colors-dashed' ) + array( esc_html__( 'Custom', 'js_composer' ) => 'custom' ),
			'description' => esc_html__( 'Select outline color.', 'js_composer' ),
			'param_holder_class' => 'vc_colored-dropdown',
			'std' => 'white',
			'dependency' => array(
				'element' => 'stroke_width',
				'value_not_equal_to' => '0',
			),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom outline color', 'js_composer' ),
			'param_name' => 'custom_stroke_color',
			'description' => esc_html__( 'Select custom outline color.', 'js_composer' ),
			'dependency' => array(
				'element' => 'stroke_color',
				'value' => array( 'custom' ),
			),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Show legend?', 'js_composer' ),
			'param_name' => 'legend',
			'description' => esc_html__( 'If checked, chart will have legend.', 'js_composer' ),
			'value' => array( esc_html__( 'Yes', 'js_composer' ) => 'yes' ),
			'std' => 'yes',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Legend color', 'js_composer' ),
			'param_name' => 'legend_color',
			'value' => vc_get_shared( 'colors-dashed' ) + array( esc_html__( 'Custom', 'js_composer' ) => 'custom' ),
			'description' => esc_html__( 'Select legend color.', 'js_composer' ),
			'param_holder_class' => 'vc_colored-dropdown',
			'std' => 'black',
			'dependency' => array(
				'element' => 'legend',
				'value' => 'yes',
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Legend position', 'js_composer' ),
			'param_name' => 'legend_position',
			'value' => array(
				esc_html__( 'Top', 'js_composer' ) => 'top',
				esc_html__( 'Left', 'js_composer' ) => 'left',
				esc_html__( 'Bottom', 'js_composer' ) => 'bottom',
				esc_html__( 'Right', 'js_composer' ) => 'right',
			),
			'description' => esc_html__( 'Select legend position.', 'js_composer' ),
			'std' => 'left',
			'dependency' => array(
				'element' => 'legend',
				'value' => 'yes',
			),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom legend color', 'js_composer' ),
			'param_name' => 'custom_legend_color',
			'description' => esc_html__( 'Select custom legend color.', 'js_composer' ),
			'dependency' => array(
				'element' => 'legend_color',
				'value' => array( 'custom' ),
			),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Show hover values?', 'js_composer' ),
			'param_name' => 'tooltips',
			'description' => esc_html__( 'If checked, chart will show values on hover.', 'js_composer' ),
			'value' => array( esc_html__( 'Yes', 'js_composer' ) => 'yes' ),
			'std' => 'yes',
		),
		array(
			'type' => 'param_group',
			'heading' => esc_html__( 'Values', 'js_composer' ),
			'param_name' => 'values',
			'value' => rawurlencode( wp_json_encode( array(
				array(
					'title' => esc_html__( 'One', 'js_composer' ),
					'value' => '60',
					'color' => 'blue',
				),
				array(
					'title' => esc_html__( 'Two', 'js_composer' ),
					'value' => '40',
					'color' => 'pink',
				),
			) ) ),
			'params' => array(
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Title', 'js_composer' ),
					'param_name' => 'title',
					'description' => esc_html__( 'Enter title for chart area.', 'js_composer' ),
					'admin_label' => true,
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Value', 'js_composer' ),
					'param_name' => 'value',
					'description' => esc_html__( 'Enter value for area.', 'js_composer' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Color', 'js_composer' ),
					'param_name' => 'color',
					'value' => vc_get_shared( 'colors-dashed' ),
					'description' => esc_html__( 'Select area color.', 'js_composer' ),
					'param_holder_class' => 'vc_colored-dropdown',
				),
				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( 'Custom color', 'js_composer' ),
					'param_name' => 'custom_color',
					'description' => esc_html__( 'Select custom area color.', 'js_composer' ),
				),
			),
			'callbacks' => array(
				'after_add' => 'vcChartParamAfterAddCallback',
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Animation', 'js_composer' ),
			'description' => esc_html__( 'Select animation style.', 'js_composer' ),
			'param_name' => 'animation',
			'value' => vc_get_shared( 'animation styles' ),
			'std' => 'easeInOutCubic',
		),
		vc_map_add_css_animation(),
		array(
			'type' => 'el_id',
			'heading' => esc_html__( 'Element ID', 'js_composer' ),
			'param_name' => 'el_id',
			'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'js_composer' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'js_composer' ),
			'value' => array(
				'margin-bottom' => '35px',
			),
		),
	),
);
vc-custom-heading-element.php                                                                                                                                                                                                                                  4452          1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_custom_heading] shortcode of 'Custom Heading' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 *
 * @return array
 */
function vc_custom_heading_element_params() {
	return array(
		'name' => esc_html__( 'Custom Heading', 'js_composer' ),
		'base' => 'vc_custom_heading',
		'icon' => 'icon-wpb-ui-custom_heading',
		'element_default_class' => 'vc_do_custom_heading',
		'show_settings_on_create' => true,
		'category' => esc_html__( 'Content', 'js_composer' ),
		'description' => esc_html__( 'Text with Google fonts', 'js_composer' ),
		'params' => array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Text source', 'js_composer' ),
				'param_name' => 'source',
				'value' => array(
					esc_html__( 'Custom text', 'js_composer' ) => '',
					esc_html__( 'Post or Page Title', 'js_composer' ) => 'post_title',
				),
				'std' => '',
				'description' => esc_html__( 'Select text source.', 'js_composer' ),
			),
			array(
				'type' => 'textarea',
				'heading' => esc_html__( 'Text', 'js_composer' ),
				'param_name' => 'text',
				'admin_label' => true,
				'value' => esc_html__( 'This is custom heading element', 'js_composer' ),
				'description' => esc_html__( 'Note: If you are using non-latin characters be sure to activate them under Settings/WPBakery Page Builder/General Settings.', 'js_composer' ),
				'dependency' => array(
					'element' => 'source',
					'is_empty' => true,
				),
			),
			array(
				'type' => 'vc_link',
				'heading' => esc_html__( 'URL (Link)', 'js_composer' ),
				'param_name' => 'link',
				'description' => esc_html__( 'Add link to custom heading.', 'js_composer' ),
				// compatible with btn2 and converted from href{btn1}.
			),
			array(
				'type' => 'font_container',
				'param_name' => 'font_container',
				'value' => 'tag:h2|text_align:left',
				'settings' => array(
					'fields' => array(
						'tag' => 'h2',
						// default value h2.
						'text_align',
						'font_size',
						'line_height',
						'color',
						'tag_description' => esc_html__( 'Select element tag.', 'js_composer' ),
						'text_align_description' => esc_html__( 'Select text alignment.', 'js_composer' ),
						'font_size_description' => esc_html__( 'Enter font size.', 'js_composer' ),
						'line_height_description' => esc_html__( 'Enter line height.', 'js_composer' ),
						'color_description' => esc_html__( 'Select heading color.', 'js_composer' ),
					),
				),
			),
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Use theme default font family?', 'js_composer' ),
				'param_name' => 'use_theme_fonts',
				'value' => array( esc_html__( 'Yes', 'js_composer' ) => 'yes' ),
				'description' => esc_html__( 'Use font family from the theme.', 'js_composer' ),
			),
			array(
				'type' => 'google_fonts',
				'param_name' => 'google_fonts',
				'value' => 'font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal',
				'settings' => array(
					'fields' => array(
						'font_family_description' => esc_html__( 'Select font family.', 'js_composer' ),
						'font_style_description' => esc_html__( 'Select font styling.', 'js_composer' ),
					),
				),
				'dependency' => array(
					'element' => 'use_theme_fonts',
					'value_not_equal_to' => 'yes',
				),
			),
			vc_map_add_css_animation(),
			array(
				'type' => 'el_id',
				'heading' => esc_html__( 'Element ID', 'js_composer' ),
				'param_name' => 'el_id',
				'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Extra class name', 'js_composer' ),
				'param_name' => 'el_class',
				'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
			),
			array(
				'type' => 'css_editor',
				'heading' => esc_html__( 'CSS box', 'js_composer' ),
				'param_name' => 'css',
				'group' => esc_html__( 'Design Options', 'js_composer' ),
				'value' => array(
					'margin-bottom' => '0.625rem',
					'margin-top' => '0',
				),
			),
		),
	);
}
shortcode-vc-custom-heading.php                                                                                                                                                                                                                                390           1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_custom_heading] shortcode of 'Custom Heading' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

require_once vc_path_dir( 'CONFIG_DIR', 'content/vc-custom-heading-element.php' );

return vc_custom_heading_element_params();
shortcode-vc-flickr.php                                                                                                                                                                                                                                        3231          1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_flickr] shortcode of 'Flickr Widget' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

return array(
	'base' => 'vc_flickr',
	'name' => esc_html__( 'Flickr Widget', 'js_composer' ),
	'icon' => 'icon-wpb-flickr',
	'element_default_class' => 'wpb_content_element',
	'category' => esc_html__( 'Content', 'js_composer' ),
	'description' => esc_html__( 'Image feed from Flickr account', 'js_composer' ),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Widget title', 'js_composer' ),
			'param_name' => 'title',
			'description' => esc_html__( 'Enter text used as widget title (Note: located above content element).', 'js_composer' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Flickr ID', 'js_composer' ),
			'param_name' => 'flickr_id',
			'value' => '95572727@N00',
			'admin_label' => true,
			'description' => sprintf( esc_html__( 'To find your flickID visit %s.', 'js_composer' ), '<a href="https://www.webfx.com/tools/idgettr/" target="_blank">idGettr</a>' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Number of photos', 'js_composer' ),
			'param_name' => 'count',
			'value' => array(
				20,
				19,
				18,
				17,
				16,
				15,
				14,
				13,
				12,
				11,
				10,
				9,
				8,
				7,
				6,
				5,
				4,
				3,
				2,
				1,
			),
			'std' => 9, // bc.
			'description' => esc_html__( 'Select number of photos to display.', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Type', 'js_composer' ),
			'param_name' => 'type',
			'value' => array(
				esc_html__( 'User', 'js_composer' ) => 'user',
				esc_html__( 'Group', 'js_composer' ) => 'group',
			),
			'description' => esc_html__( 'Select photo stream type.', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Display order', 'js_composer' ),
			'param_name' => 'display',
			'value' => array(
				esc_html__( 'Latest first', 'js_composer' ) => 'latest',
				esc_html__( 'Random', 'js_composer' ) => 'random',
			),
			'description' => esc_html__( 'Select photo display order.', 'js_composer' ),
		),
		vc_map_add_css_animation(),
		array(
			'type' => 'el_id',
			'heading' => esc_html__( 'Element ID', 'js_composer' ),
			'param_name' => 'el_id',
			'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'js_composer' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'js_composer' ),
			'value' => array(
				'margin-bottom' => '35px',
			),
		),
	),
);
shortcode-vc-message.php                                                                                                                                                                                                                                       10742         1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_message] shortcode of 'Message Box' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

$pixel_icons = vc_pixel_icons();
$custom_colors = array(
	esc_html__( 'Informational', 'js_composer' ) => 'info',
	esc_html__( 'Warning', 'js_composer' ) => 'warning',
	esc_html__( 'Success', 'js_composer' ) => 'success',
	esc_html__( 'Error', 'js_composer' ) => 'danger',
	esc_html__( 'Informational Classic', 'js_composer' ) => 'alert-info',
	esc_html__( 'Warning Classic', 'js_composer' ) => 'alert-warning',
	esc_html__( 'Success Classic', 'js_composer' ) => 'alert-success',
	esc_html__( 'Error Classic', 'js_composer' ) => 'alert-danger',
);

return array(
	'name' => esc_html__( 'Message Box', 'js_composer' ),
	'base' => 'vc_message',
	'icon' => 'icon-wpb-information-white',
	'element_default_class' => 'vc_do_message',
	'category' => esc_html__( 'Content', 'js_composer' ),
	'description' => esc_html__( 'Notification box', 'js_composer' ),
	'params' => array(
		array(
			'type' => 'params_preset',
			'heading' => esc_html__( 'Message Box Presets', 'js_composer' ),
			'param_name' => 'color',
			// due to backward compatibility, really it is message_box_type.
			'value' => '',
			'options' => array(
				array(
					'label' => esc_html__( 'Custom', 'js_composer' ),
					'value' => '',
					'params' => array(),
				),
				array(
					'label' => esc_html__( 'Informational', 'js_composer' ),
					'value' => 'info',
					'params' => array(
						'message_box_color' => 'info',
						'icon_type' => 'fontawesome',
						'icon_fontawesome' => 'fas fa-info-circle',
					),
				),
				array(
					'label' => esc_html__( 'Warning', 'js_composer' ),
					'value' => 'warning',
					'params' => array(
						'message_box_color' => 'warning',
						'icon_type' => 'fontawesome',
						'icon_fontawesome' => 'fas fa-exclamation-triangle',
					),
				),
				array(
					'label' => esc_html__( 'Success', 'js_composer' ),
					'value' => 'success',
					'params' => array(
						'message_box_color' => 'success',
						'icon_type' => 'fontawesome',
						'icon_fontawesome' => 'fas fa-check',
					),
				),
				array(
					'label' => esc_html__( 'Error', 'js_composer' ),
					'value' => 'danger',
					'params' => array(
						'message_box_color' => 'danger',
						'icon_type' => 'fontawesome',
						'icon_fontawesome' => 'fas fa-times',
					),
				),
				array(
					'label' => esc_html__( 'Informational Classic', 'js_composer' ),
					'value' => 'alert-info',
					// due to backward compatibility.
					'params' => array(
						'message_box_color' => 'alert-info',
						'icon_type' => 'pixelicons',
						'icon_pixelicons' => 'vc_pixel_icon vc_pixel_icon-info',
					),
				),
				array(
					'label' => esc_html__( 'Warning Classic', 'js_composer' ),
					'value' => 'alert-warning',
					// due to backward compatibility.
					'params' => array(
						'message_box_color' => 'alert-warning',
						'icon_type' => 'pixelicons',
						'icon_pixelicons' => 'vc_pixel_icon vc_pixel_icon-alert',
					),
				),
				array(
					'label' => esc_html__( 'Success Classic', 'js_composer' ),
					'value' => 'alert-success',
					// due to backward compatibility.
					'params' => array(
						'message_box_color' => 'alert-success',
						'icon_type' => 'pixelicons',
						'icon_pixelicons' => 'vc_pixel_icon vc_pixel_icon-tick',
					),
				),
				array(
					'label' => esc_html__( 'Error Classic', 'js_composer' ),
					'value' => 'alert-danger',
					// due to backward compatibility.
					'params' => array(
						'message_box_color' => 'alert-danger',
						'icon_type' => 'pixelicons',
						'icon_pixelicons' => 'vc_pixel_icon vc_pixel_icon-explanation',
					),
				),
			),
			'description' => esc_html__( 'Select predefined message box design or choose "Custom" for custom styling.', 'js_composer' ),
			'param_holder_class' => 'vc_message-type vc_colored-dropdown',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Style', 'js_composer' ),
			'param_name' => 'message_box_style',
			'value' => vc_get_shared( 'message_box_styles' ),
			'description' => esc_html__( 'Select message box design style.', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Shape', 'js_composer' ),
			'param_name' => 'style',
			// due to backward compatibility message_box_shape.
			'std' => 'rounded',
			'value' => array(
				esc_html__( 'Square', 'js_composer' ) => 'square',
				esc_html__( 'Rounded', 'js_composer' ) => 'rounded',
				esc_html__( 'Round', 'js_composer' ) => 'round',
			),
			'description' => esc_html__( 'Select message box shape.', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Color', 'js_composer' ),
			'param_name' => 'message_box_color',
			'value' => $custom_colors + vc_get_shared( 'colors' ),
			'description' => esc_html__( 'Select message box color.', 'js_composer' ),
			'param_holder_class' => 'vc_message-type vc_colored-dropdown',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Icon library', 'js_composer' ),
			'value' => array(
				esc_html__( 'Font Awesome 5', 'js_composer' ) => 'fontawesome',
				esc_html__( 'Open Iconic', 'js_composer' ) => 'openiconic',
				esc_html__( 'Typicons', 'js_composer' ) => 'typicons',
				esc_html__( 'Entypo', 'js_composer' ) => 'entypo',
				esc_html__( 'Linecons', 'js_composer' ) => 'linecons',
				esc_html__( 'Pixel', 'js_composer' ) => 'pixelicons',
				esc_html__( 'Mono Social', 'js_composer' ) => 'monosocial',
			),
			'param_name' => 'icon_type',
			'description' => esc_html__( 'Choose icon library.', 'js_composer' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'js_composer' ),
			'param_name' => 'icon_fontawesome',
			'value' => 'fas fa-info-circle',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon.
				'iconsPerPage' => 500,
				// default 100, how many icons per/page to display.
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'fontawesome',
			),
			'description' => esc_html__( 'Choose icon from library.', 'js_composer' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'js_composer' ),
			'param_name' => 'icon_openiconic',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon.
				'type' => 'openiconic',
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display.
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'openiconic',
			),
			'description' => esc_html__( 'Choose icon from library.', 'js_composer' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'js_composer' ),
			'param_name' => 'icon_typicons',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon.
				'type' => 'typicons',
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display.
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'typicons',
			),
			'description' => esc_html__( 'Choose icon from library.', 'js_composer' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'js_composer' ),
			'param_name' => 'icon_entypo',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon.
				'type' => 'entypo',
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display.
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'entypo',
			),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'js_composer' ),
			'param_name' => 'icon_linecons',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon.
				'type' => 'linecons',
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display.
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'linecons',
			),
			'description' => esc_html__( 'Choose icon from library.', 'js_composer' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'js_composer' ),
			'param_name' => 'icon_pixelicons',
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon.
				'type' => 'pixelicons',
				'source' => $pixel_icons,
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'pixelicons',
			),
			'description' => esc_html__( 'Choose icon from library.', 'js_composer' ),
		),
		array(
			'type' => 'iconpicker',
			'heading' => esc_html__( 'Icon', 'js_composer' ),
			'param_name' => 'icon_monosocial',
			'value' => 'vc-mono vc-mono-fivehundredpx',
			// default value to backend editor admin_label.
			'settings' => array(
				'emptyIcon' => false,
				// default true, display an "EMPTY" icon.
				'type' => 'monosocial',
				'iconsPerPage' => 4000,
				// default 100, how many icons per/page to display.
			),
			'dependency' => array(
				'element' => 'icon_type',
				'value' => 'monosocial',
			),
			'description' => esc_html__( 'Choose icon from library.', 'js_composer' ),
		),
		array(
			'type' => 'textarea_html',
			'holder' => 'div',
			'class' => 'messagebox_text',
			'heading' => esc_html__( 'Message text', 'js_composer' ),
			'param_name' => 'content',
			'value' => '<p>' . esc_html__( 'I am message box. Click edit button to change this text.', 'js_composer' ) . '</p>',
		),
		vc_map_add_css_animation( false ),
		array(
			'type' => 'el_id',
			'heading' => esc_html__( 'Element ID', 'js_composer' ),
			'param_name' => 'el_id',
			'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'js_composer' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'js_composer' ),
			'value' => array(
				'padding-top' => '1em',
				'padding-bottom' => '1em',
				'padding-right' => '1em',
				'padding-left' => '4em',
				'margin-bottom' => '22px',
			),
		),
	),
	'js_view' => 'VcMessageView_Backend',
);
shortcode-vc-hoverbox.php                                                                                                                                                                                                                                      9847          1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_cta] shortcode of 'Hover Box' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

require_once vc_path_dir( 'CONFIG_DIR', 'content/vc-custom-heading-element.php' );
$h2_custom_heading = vc_map_integrate_shortcode( vc_custom_heading_element_params(), 'primary_title_', esc_html__( 'Primary Title', 'js_composer' ), array(
	'exclude' => array(
		'source',
		'text',
		'css',
	),
), array(
	'element' => 'use_custom_fonts_primary_title',
	'value' => 'true',
) );

// This is needed to remove custom heading _tag and _align options.
if ( is_array( $h2_custom_heading ) && ! empty( $h2_custom_heading ) ) {
	foreach ( $h2_custom_heading as $key => $param ) {
		if ( is_array( $param ) && isset( $param['type'] ) && 'font_container' === $param['type'] ) {
			$h2_custom_heading[ $key ]['value'] = '';
			if ( isset( $param['settings'] ) && is_array( $param['settings'] ) && isset( $param['settings']['fields'] ) ) {
				$sub_key = array_search( 'tag', $param['settings']['fields'], true );
				if ( false !== $sub_key ) {
					unset( $h2_custom_heading[ $key ]['settings']['fields'][ $sub_key ] );
				} elseif ( isset( $param['settings']['fields']['tag'] ) ) {
					unset( $h2_custom_heading[ $key ]['settings']['fields']['tag'] );
				}
				$sub_key = array_search( 'text_align', $param['settings']['fields'], true );
				if ( false !== $sub_key ) {
					unset( $h2_custom_heading[ $key ]['settings']['fields'][ $sub_key ] );
				} elseif ( isset( $param['settings']['fields']['text_align'] ) ) {
					unset( $h2_custom_heading[ $key ]['settings']['fields']['text_align'] );
				}
			}
		}
	}
}
$h4_custom_heading = vc_map_integrate_shortcode( vc_custom_heading_element_params(), 'hover_title_', esc_html__( 'Hover Title', 'js_composer' ), array(
	'exclude' => array(
		'source',
		'text',
		'css',
	),
), array(
	'element' => 'use_custom_fonts_hover_title',
	'value' => 'true',
) );

// This is needed to remove custom heading _tag and _align options.
if ( is_array( $h4_custom_heading ) && ! empty( $h4_custom_heading ) ) {
	foreach ( $h4_custom_heading as $key => $param ) {
		if ( is_array( $param ) && isset( $param['type'] ) && 'font_container' === $param['type'] ) {
			$h4_custom_heading[ $key ]['value'] = '';
			if ( isset( $param['settings'] ) && is_array( $param['settings'] ) && isset( $param['settings']['fields'] ) ) {
				$sub_key = array_search( 'tag', $param['settings']['fields'], true );
				if ( false !== $sub_key ) {
					unset( $h4_custom_heading[ $key ]['settings']['fields'][ $sub_key ] );
				} elseif ( isset( $param['settings']['fields']['tag'] ) ) {
					unset( $h4_custom_heading[ $key ]['settings']['fields']['tag'] );
				}
				$sub_key = array_search( 'text_align', $param['settings']['fields'], true );
				if ( false !== $sub_key ) {
					unset( $h4_custom_heading[ $key ]['settings']['fields'][ $sub_key ] );
				} elseif ( isset( $param['settings']['fields']['text_align'] ) ) {
					unset( $h4_custom_heading[ $key ]['settings']['fields']['text_align'] );
				}
			}
		}
	}
}
$params = array_merge( array(
	array(
		'type' => 'attach_image',
		'heading' => esc_html__( 'Image', 'js_composer' ),
		'param_name' => 'image',
		'value' => '',
		'description' => esc_html__( 'Select image from media library.', 'js_composer' ),
		'admin_label' => true,
	),
	array(
		'type' => 'textfield',
		'heading' => esc_html__( 'Primary title', 'js_composer' ),
		'admin_label' => true,
		'param_name' => 'primary_title',
		'value' => esc_html__( 'Hover Box Element', 'js_composer' ),
		'description' => esc_html__( 'Enter text for heading line.', 'js_composer' ),
		'edit_field_class' => 'vc_col-sm-9',
	),
	array(
		'type' => 'checkbox',
		'heading' => esc_html__( 'Use custom font?', 'js_composer' ),
		'param_name' => 'use_custom_fonts_primary_title',
		'description' => esc_html__( 'Enable Google fonts.', 'js_composer' ),
		'edit_field_class' => 'vc_col-sm-3',
	),
	array(
		'type' => 'dropdown',
		'heading' => esc_html__( 'Primary title alignment', 'js_composer' ),
		'param_name' => 'primary_align',
		'value' => vc_get_shared( 'text align' ),
		'std' => 'center',
		'description' => esc_html__( 'Select text alignment for primary title.', 'js_composer' ),
	),
), $h2_custom_heading, array(
	array(
		'type' => 'textfield',
		'heading' => esc_html__( 'Hover title', 'js_composer' ),
		'param_name' => 'hover_title',
		'value' => 'Hover Box Element',
		'description' => esc_html__( 'Hover Box Element', 'js_composer' ),
		'group' => esc_html__( 'Hover Block', 'js_composer' ),
		'edit_field_class' => 'vc_col-sm-9',
	),
	array(
		'type' => 'checkbox',
		'heading' => esc_html__( 'Use custom font?', 'js_composer' ),
		'param_name' => 'use_custom_fonts_hover_title',
		'description' => esc_html__( 'Enable custom font option.', 'js_composer' ),
		'group' => esc_html__( 'Hover Block', 'js_composer' ),
		'edit_field_class' => 'vc_col-sm-3',
	),
	array(
		'type' => 'dropdown',
		'heading' => esc_html__( 'Hover title alignment', 'js_composer' ),
		'param_name' => 'hover_align',
		'value' => vc_get_shared( 'text align' ),
		'std' => 'center',
		'group' => esc_html__( 'Hover Block', 'js_composer' ),
		'description' => esc_html__( 'Select text alignment for hovered title.', 'js_composer' ),
	),
	array(
		'type' => 'textarea_html',
		'heading' => esc_html__( 'Hover text', 'js_composer' ),
		'param_name' => 'content',
		'value' => esc_html__( 'Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'js_composer' ),
		'group' => esc_html__( 'Hover Block', 'js_composer' ),
		'description' => esc_html__( 'Hover part text.', 'js_composer' ),
	),
), $h4_custom_heading, array(
	array(
		'type' => 'dropdown',
		'heading' => esc_html__( 'Shape', 'js_composer' ),
		'param_name' => 'shape',
		'std' => 'rounded',
		'value' => array(
			esc_html__( 'Square', 'js_composer' ) => 'square',
			esc_html__( 'Rounded', 'js_composer' ) => 'rounded',
			esc_html__( 'Round', 'js_composer' ) => 'round',
		),
		'description' => esc_html__( 'Select block shape.', 'js_composer' ),
	),
	array(
		'type' => 'dropdown',
		'heading' => esc_html__( 'Background Color', 'js_composer' ),
		'param_name' => 'hover_background_color',
		'value' => vc_get_shared( 'colors-dashed' ) + array( esc_html__( 'Custom', 'js_composer' ) => 'custom' ),
		'description' => esc_html__( 'Select color schema.', 'js_composer' ),
		'std' => 'grey',
		'group' => esc_html__( 'Hover Block', 'js_composer' ),
		'param_holder_class' => 'vc_colored-dropdown vc_cta3-colored-dropdown',
	),
	array(
		'type' => 'colorpicker',
		'heading' => esc_html__( 'Background color', 'js_composer' ),
		'param_name' => 'hover_custom_background',
		'description' => esc_html__( 'Select custom background color.', 'js_composer' ),
		'group' => esc_html__( 'Hover Block', 'js_composer' ),
		'dependency' => array(
			'element' => 'hover_background_color',
			'value' => array( 'custom' ),
		),
		'edit_field_class' => 'vc_col-sm-6',
	),
	array(
		'type' => 'dropdown',
		'heading' => esc_html__( 'Width', 'js_composer' ),
		'param_name' => 'el_width',
		'value' => array(
			'100%' => '100',
			'90%' => '90',
			'80%' => '80',
			'70%' => '70',
			'60%' => '60',
			'50%' => '50',
			'40%' => '40',
			'30%' => '30',
			'20%' => '20',
			'10%' => '10',
		),
		'description' => esc_html__( 'Select block width (percentage).', 'js_composer' ),
	),
	array(
		'type' => 'dropdown',
		'heading' => esc_html__( 'Alignment', 'js_composer' ),
		'param_name' => 'align',
		'description' => esc_html__( 'Select block alignment.', 'js_composer' ),
		'value' => array(
			esc_html__( 'Left', 'js_composer' ) => 'left',
			esc_html__( 'Right', 'js_composer' ) => 'right',
			esc_html__( 'Center', 'js_composer' ) => 'center',
		),
		'std' => 'center',
	),
	array(
		'type' => 'checkbox',
		'heading' => esc_html__( 'Add button', 'js_composer' ) . '?',
		'description' => esc_html__( 'Add button for call to action.', 'js_composer' ),
		'group' => esc_html__( 'Hover Block', 'js_composer' ),
		'param_name' => 'hover_add_button',
	),
	array(
		'type' => 'checkbox',
		'heading' => esc_html__( 'Reverse blocks', 'js_composer' ),
		'param_name' => 'reverse',
		'description' => esc_html__( 'Reverse hover and primary block.', 'js_composer' ),
	),
), vc_map_integrate_shortcode( 'vc_btn', 'hover_btn_', esc_html__( 'Hover Button', 'js_composer' ), array(
	'exclude' => array( 'css' ),
), array(
	'element' => 'hover_add_button',
	'not_empty' => true,
) ), array(
	vc_map_add_css_animation(),
	array(
		'type' => 'el_id',
		'heading' => esc_html__( 'Element ID', 'js_composer' ),
		'param_name' => 'el_id',
		'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
	),
	array(
		'type' => 'textfield',
		'heading' => esc_html__( 'Extra class name', 'js_composer' ),
		'param_name' => 'el_class',
		'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
	),
	array(
		'type' => 'css_editor',
		'heading' => esc_html__( 'CSS box', 'js_composer' ),
		'param_name' => 'css',
		'group' => esc_html__( 'Design Options', 'js_composer' ),
	),
) );

return array(
	'name' => esc_html__( 'Hover Box', 'js_composer' ),
	'base' => 'vc_cta',
	'icon' => 'vc_icon-vc-hoverbox',
	'category' => array( esc_html__( 'Content', 'js_composer' ) ),
	'description' => esc_html__( 'Animated flip box with image and text', 'js_composer' ),
	'params' => $params,
);
shortcode-vc-separator.php                                                                                                                                                                                                                                     3478          1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_separator] shortcode of 'Separator' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

return array(
	'name' => esc_html__( 'Separator', 'js_composer' ),
	'base' => 'vc_separator',
	'icon' => 'icon-wpb-ui-separator',
	'element_default_class' => 'wpb_content_element',
	'show_settings_on_create' => true,
	'category' => esc_html__( 'Content', 'js_composer' ),
	'description' => esc_html__( 'Horizontal separator line', 'js_composer' ),
	'params' => array(
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Color', 'js_composer' ),
			'param_name' => 'color',
			'value' => array_merge( vc_get_shared( 'colors' ), array( esc_html__( 'Custom color', 'js_composer' ) => 'custom' ) ),
			'std' => 'grey',
			'description' => esc_html__( 'Select color of separator.', 'js_composer' ),
			'param_holder_class' => 'vc_colored-dropdown',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Alignment', 'js_composer' ),
			'param_name' => 'align',
			'value' => array(
				esc_html__( 'Center', 'js_composer' ) => 'align_center',
				esc_html__( 'Left', 'js_composer' ) => 'align_left',
				esc_html__( 'Right', 'js_composer' ) => 'align_right',
			),
			'description' => esc_html__( 'Select separator alignment.', 'js_composer' ),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Border Color', 'js_composer' ),
			'param_name' => 'accent_color',
			'description' => esc_html__( 'Select border color for your element.', 'js_composer' ),
			'dependency' => array(
				'element' => 'color',
				'value' => array( 'custom' ),
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Style', 'js_composer' ),
			'param_name' => 'style',
			'value' => vc_get_shared( 'separator styles' ),
			'description' => esc_html__( 'Separator display style.', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Border width', 'js_composer' ),
			'param_name' => 'border_width',
			'value' => vc_get_shared( 'separator border widths' ),
			'description' => esc_html__( 'Select border width (pixels).', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Element width', 'js_composer' ),
			'param_name' => 'el_width',
			'value' => vc_get_shared( 'separator widths' ),
			'description' => esc_html__( 'Select separator width (percentage).', 'js_composer' ),
		),
		vc_map_add_css_animation(),
		array(
			'type' => 'el_id',
			'heading' => esc_html__( 'Element ID', 'js_composer' ),
			'param_name' => 'el_id',
			'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'js_composer' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'js_composer' ),
			'value' => array(
				'margin-bottom' => '35px',
			),
		),
	),
);
shortcode-vc-progress-bar.php                                                                                                                                                                                                                                  6677          1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_progress_bar] shortcode of 'Progress Bar' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

$color_value = array_merge( array(
	esc_html__( 'Default', 'js_composer' ) => '',
), array(
	esc_html__( 'Classic Grey', 'js_composer' ) => 'bar_grey',
	esc_html__( 'Classic Blue', 'js_composer' ) => 'bar_blue',
	esc_html__( 'Classic Turquoise', 'js_composer' ) => 'bar_turquoise',
	esc_html__( 'Classic Green', 'js_composer' ) => 'bar_green',
	esc_html__( 'Classic Orange', 'js_composer' ) => 'bar_orange',
	esc_html__( 'Classic Red', 'js_composer' ) => 'bar_red',
	esc_html__( 'Classic Black', 'js_composer' ) => 'bar_black',
), vc_get_shared( 'colors-dashed' ), array(
	esc_html__( 'Custom Color', 'js_composer' ) => 'custom',
) );

$bg_color_value = array_merge( array(
	esc_html__( 'Classic Grey', 'js_composer' ) => 'bar_grey',
	esc_html__( 'Classic Blue', 'js_composer' ) => 'bar_blue',
	esc_html__( 'Classic Turquoise', 'js_composer' ) => 'bar_turquoise',
	esc_html__( 'Classic Green', 'js_composer' ) => 'bar_green',
	esc_html__( 'Classic Orange', 'js_composer' ) => 'bar_orange',
	esc_html__( 'Classic Red', 'js_composer' ) => 'bar_red',
	esc_html__( 'Classic Black', 'js_composer' ) => 'bar_black',
), vc_get_shared( 'colors-dashed' ), array(
	esc_html__( 'Custom Color', 'js_composer' ) => 'custom',
) );

return array(
	'name' => esc_html__( 'Progress Bar', 'js_composer' ),
	'base' => 'vc_progress_bar',
	'icon' => 'icon-wpb-graph',
	'element_default_class' => 'wpb_content_element',
	'category' => esc_html__( 'Content', 'js_composer' ),
	'description' => esc_html__( 'Animated progress bar', 'js_composer' ),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Widget title', 'js_composer' ),
			'param_name' => 'title',
			'description' => esc_html__( 'Enter text used as widget title (Note: located above content element).', 'js_composer' ),
		),
		array(
			'type' => 'param_group',
			'heading' => esc_html__( 'Values', 'js_composer' ),
			'param_name' => 'values',
			'description' => esc_html__( 'Enter values for graph - value, title and color.', 'js_composer' ),
			'value' => rawurlencode( wp_json_encode( array(
				array(
					'label' => esc_html__( 'Development', 'js_composer' ),
					'value' => '90',
				),
				array(
					'label' => esc_html__( 'Design', 'js_composer' ),
					'value' => '80',
				),
				array(
					'label' => esc_html__( 'Marketing', 'js_composer' ),
					'value' => '70',
				),
			) ) ),
			'params' => array(
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Label', 'js_composer' ),
					'param_name' => 'label',
					'description' => esc_html__( 'Enter text used as title of bar.', 'js_composer' ),
					'admin_label' => true,
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Value', 'js_composer' ),
					'param_name' => 'value',
					'description' => esc_html__( 'Enter value of bar.', 'js_composer' ),
					'admin_label' => true,
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Color', 'js_composer' ),
					'param_name' => 'color',
					'value' => $color_value,
					'description' => esc_html__( 'Select single bar background color.', 'js_composer' ),
					'admin_label' => true,
					'param_holder_class' => 'vc_colored-dropdown',
				),
				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( 'Custom color', 'js_composer' ),
					'param_name' => 'customcolor',
					'description' => esc_html__( 'Select custom single bar background color.', 'js_composer' ),
					'dependency' => array(
						'element' => 'color',
						'value' => array( 'custom' ),
					),
				),
				array(
					'type' => 'colorpicker',
					'heading' => esc_html__( 'Custom text color', 'js_composer' ),
					'param_name' => 'customtxtcolor',
					'description' => esc_html__( 'Select custom single bar text color.', 'js_composer' ),
					'dependency' => array(
						'element' => 'color',
						'value' => array( 'custom' ),
					),
				),
			),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Units', 'js_composer' ),
			'param_name' => 'units',
			'description' => esc_html__( 'Enter measurement units (Example: %, px, points, etc. Note: graph value and units will be appended to graph title).', 'js_composer' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Color', 'js_composer' ),
			'param_name' => 'bgcolor',
			'value' => $bg_color_value,
			'description' => esc_html__( 'Select bar color.', 'js_composer' ),
			'admin_label' => true,
			'param_holder_class' => 'vc_colored-dropdown',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Bar custom background color', 'js_composer' ),
			'param_name' => 'custombgcolor',
			'description' => esc_html__( 'Select custom background color for bars.', 'js_composer' ),
			'dependency' => array(
				'element' => 'bgcolor',
				'value' => array( 'custom' ),
			),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Bar custom text color', 'js_composer' ),
			'param_name' => 'customtxtcolor',
			'description' => esc_html__( 'Select custom text color for bars.', 'js_composer' ),
			'dependency' => array(
				'element' => 'bgcolor',
				'value' => array( 'custom' ),
			),
		),
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Options', 'js_composer' ),
			'param_name' => 'options',
			'value' => array(
				esc_html__( 'Add stripes', 'js_composer' ) => 'striped',
				esc_html__( 'Add animation (Note: visible only with striped bar).', 'js_composer' ) => 'animated',
			),
		),
		vc_map_add_css_animation(),
		array(
			'type' => 'el_id',
			'heading' => esc_html__( 'Element ID', 'js_composer' ),
			'param_name' => 'el_id',
			'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'js_composer' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'js_composer' ),
			'value' => array(
				'margin-bottom' => '35px',
			),
		),
	),
);
shortcode-vc-empty-space.php                                                                                                                                                                                                                                   1718          1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_empty_space] shortcode of 'Empty Space' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

return array(
	'name' => esc_html__( 'Empty Space', 'js_composer' ),
	'base' => 'vc_empty_space',
	'icon' => 'icon-wpb-ui-empty_space',
	'show_settings_on_create' => true,
	'category' => esc_html__( 'Content', 'js_composer' ),
	'description' => esc_html__( 'Blank space with custom height', 'js_composer' ),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Height', 'js_composer' ),
			'param_name' => 'height',
			'value' => '32px',
			'admin_label' => true,
			'description' => esc_html__( 'Enter empty space height (Note: CSS measurement units allowed).', 'js_composer' ),
		),
		array(
			'type' => 'el_id',
			'heading' => esc_html__( 'Element ID', 'js_composer' ),
			'param_name' => 'el_id',
			'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'js_composer' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'js_composer' ),
		),
	),
);
shortcode-vc-column-text.php                                                                                                                                                                                                                                   1935          1727216843  plugins/js_composer/config/content                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              <?php
/**
 * Configuration file for [vc_column_text] shortcode of 'Text Block' element.
 *
 * @see https://kb.wpbakery.com/docs/inner-api/vc_map/ for more detailed information about element attributes.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

return array(
	'name' => esc_html__( 'Text Block', 'js_composer' ),
	'icon' => 'icon-wpb-layer-shape-text',
	'wrapper_class' => 'clearfix',
	'element_default_class' => 'wpb_content_element',
	'category' => esc_html__( 'Content', 'js_composer' ),
	'description' => esc_html__( 'A block of text with WYSIWYG editor', 'js_composer' ),
	'params' => array(
		array(
			'type' => 'textarea_html',
			'holder' => 'div',
			'heading' => esc_html__( 'Text', 'js_composer' ),
			'param_name' => 'content',
			'value' => '<p>' . esc_html__( 'I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'js_composer' ) . '</p>',
		),
		vc_map_add_css_animation(),
		array(
			'type' => 'el_id',
			'heading' => esc_html__( 'Element ID', 'js_composer' ),
			'param_name' => 'el_id',
			'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %1$sw3c specification%2$s).', 'js_composer' ), '<a href="https://www.w3schools.com/tags/att_global_id.asp" target="_blank">', '</a>' ),
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Extra class name', 'js_composer' ),
			'param_name' => 'el_class',
			'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'js_composer' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'js_composer' ),
			'value' => array(
				'margin-bottom' => '35px',
			),
		),
	),
);
templates.php                                                                                                                                                                                                                                                  158878        1727216843  plugins/js_composer/config                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      <?php
/**
 * Default templates list.
 *
 * @since 4.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}


/** Landing page template */
$data = array();
$data['name'] = esc_html__( 'Landing Page', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/3"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/1"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/3"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Call to Action Page template */
$data = array();
$data['name'] = esc_html__( 'Call to Action Page', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row full_width=""][vc_column width="1/1"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_separator color="grey" align="align_center" style="" border_width="" el_width=""][/vc_column][/vc_row][vc_row full_width=""][vc_column width="1/2"][vc_single_image image="" alignment="" style="" border_color="grey" img_link_large="" img_link_target="_self" css_animation=""][/vc_column][vc_column width="1/2"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="flat" shape="rounded" color="blue" size="md" align="inline" i_align="left" i_type="fontawesome" i_icon_fontawesome="fas fa-adjust" i_icon_openiconic="vc-oi vc-oi-dial" i_icon_typicons="typcn typcn-adjust-brightness" i_icon_entypo="entypo-icon entypo-icon-note" i_icon_linecons="vc_li vc_li-heart" button_block="" add_icon="" i_icon_pixelicons="vc_pixel_icon vc_pixel_icon-alert"][/vc_column][/vc_row][vc_row full_width=""][vc_column width="1/2"][vc_single_image image="" alignment="" style="" border_color="grey" img_link_large="" img_link_target="_self" css_animation=""][/vc_column][vc_column width="1/2"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="flat" shape="rounded" color="blue" size="md" align="inline" i_align="left" i_type="fontawesome" i_icon_fontawesome="fas fa-adjust" i_icon_openiconic="vc-oi vc-oi-dial" i_icon_typicons="typcn typcn-adjust-brightness" i_icon_entypo="entypo-icon entypo-icon-note" i_icon_linecons="vc_li vc_li-heart" css_animation="" button_block="" add_icon="" i_icon_pixelicons="vc_pixel_icon vc_pixel_icon-alert"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Feature List template */
$data = array();
$data['name'] = esc_html__( 'Feature List', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/1"][vc_single_image border_color="grey" img_link_target="_self" alignment="center"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/3"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Description Page template */
$data = array();
$data['name'] = esc_html__( 'Description Page', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/1"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_single_image border_color="grey" img_link_target="_self"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Service List template */
$data = array();
$data['name'] = esc_html__( 'Service List', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2"][vc_single_image border_color="grey" img_link_target="_self"][/vc_column][vc_column width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_single_image border_color="grey" img_link_target="_self"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_single_image border_color="grey" img_link_target="_self"][/vc_column][vc_column width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_single_image border_color="grey" img_link_target="_self"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Product Page template */
$data = array();
$data['name'] = esc_html__( 'Product Page', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row full_width=""][vc_column width="1/1"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_separator color="grey" align="align_center" style="" border_width="" el_width=""][vc_single_image image="" alignment="" style="" border_color="grey" img_link_large="" img_link_target="_self" css_animation=""][vc_separator color="grey" align="align_center" style="" border_width="" el_width=""][/vc_column][/vc_row][vc_row full_width=""][vc_column width="1/2"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="flat" shape="rounded" color="blue" size="md" align="inline" i_align="left" i_type="fontawesome" i_icon_fontawesome="fas fa-adjust" i_icon_openiconic="vc-oi vc-oi-dial" i_icon_typicons="typcn typcn-adjust-brightness" i_icon_entypo="entypo-icon entypo-icon-note" i_icon_linecons="vc_li vc_li-heart" button_block="" add_icon="" i_icon_pixelicons="vc_pixel_icon vc_pixel_icon-alert"][/vc_column][vc_column width="1/2"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="flat" shape="rounded" color="blue" size="md" align="inline" i_align="left" i_type="fontawesome" i_icon_fontawesome="fas fa-adjust" i_icon_openiconic="vc-oi vc-oi-dial" i_icon_typicons="typcn typcn-adjust-brightness" i_icon_entypo="entypo-icon entypo-icon-note" i_icon_linecons="vc_li vc_li-heart" css_animation="" button_block="" add_icon="" i_icon_pixelicons="vc_pixel_icon vc_pixel_icon-alert"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );// New templates. Since 4.4.
/** FAQ section */
$data = array();
$data['name'] = esc_html__( 'FAQ section', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/1"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/1"][vc_separator color="grey"][/vc_column][/vc_row][vc_row][vc_column width="1/1"][vc_toggle title="First question" open="true"]Toggle content goes here, click edit button to change this text.[/vc_toggle][vc_toggle title="Second question" open="false"]Toggle content goes here, click edit button to change this text.[/vc_toggle][vc_toggle title="Third question" open="false"]Toggle content goes here, click edit button to change this text.[/vc_toggle][vc_toggle title="Fourth question" open="false"]Toggle content goes here, click edit button to change this text.[/vc_toggle][vc_toggle title="Fifth question" open="false"]Toggle content goes here, click edit button to change this text.[/vc_toggle][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** About section */
$data = array();
$data['name'] = esc_html__( 'About section', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="2/3"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h2|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_row_inner][vc_column_inner width="1/1"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_separator color="grey"][vc_row_inner][vc_column_inner width="1/1"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** About section */
$data = array();
$data['name'] = esc_html__( 'About with features', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/1"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/3"][vc_single_image alignment="center" border_color="grey" img_link_target="_self" style="vc_box_outline"][vc_column_text]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image alignment="center" border_color="grey" img_link_target="_self" style="vc_box_outline"][vc_column_text]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image alignment="center" border_color="grey" img_link_target="_self" style="vc_box_outline"][vc_column_text]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/1"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Three image description */
$data = array();
$data['name'] = esc_html__( 'Three image description', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/1"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column][vc_column width="1/2"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column][/vc_row][vc_row][vc_column width="1/1"][vc_column_text]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** News list */
$data = array();
$data['name'] = esc_html__( 'News list', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row full_width=""][vc_column width="1/2"][vc_single_image image="" alignment="" style="vc_box_outline" border_color="grey" img_link_large="" img_link_target="_self" css_animation=""][/vc_column][vc_column width="1/2"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h2|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="flat" shape="rounded" color="purple" size="md" align="inline" i_align="left" i_type="fontawesome" i_icon_fontawesome="fas fa-adjust" i_icon_openiconic="vc-oi vc-oi-dial" i_icon_typicons="typcn typcn-adjust-brightness" i_icon_entypo="entypo-icon entypo-icon-note" i_icon_linecons="vc_li vc_li-heart" button_block="" add_icon="" i_icon_pixelicons="vc_pixel_icon vc_pixel_icon-alert"][/vc_column][/vc_row][vc_row full_width=""][vc_column width="1/2"][vc_single_image image="" alignment="" style="vc_box_outline" border_color="grey" img_link_large="" img_link_target="_self" css_animation=""][/vc_column][vc_column width="1/2"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h2|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="flat" shape="rounded" color="purple" size="md" align="inline" i_align="left" i_type="fontawesome" i_icon_fontawesome="fas fa-adjust" i_icon_openiconic="vc-oi vc-oi-dial" i_icon_typicons="typcn typcn-adjust-brightness" i_icon_entypo="entypo-icon entypo-icon-note" i_icon_linecons="vc_li vc_li-heart" css_animation="" button_block="" add_icon="" i_icon_pixelicons="vc_pixel_icon vc_pixel_icon-alert"][/vc_column][/vc_row][vc_row full_width=""][vc_column width="1/2"][vc_single_image image="" alignment="" style="vc_box_outline" border_color="grey" img_link_large="" img_link_target="_self" css_animation=""][/vc_column][vc_column width="1/2"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h2|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="flat" shape="rounded" color="purple" size="md" align="inline" i_align="left" i_type="fontawesome" i_icon_fontawesome="fas fa-adjust" i_icon_openiconic="vc-oi vc-oi-dial" i_icon_typicons="typcn typcn-adjust-brightness" i_icon_entypo="entypo-icon entypo-icon-note" i_icon_linecons="vc_li vc_li-heart" css_animation="" button_block="" add_icon="" i_icon_pixelicons="vc_pixel_icon vc_pixel_icon-alert"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Product description */
$data = array();
$data['name'] = esc_html__( 'Product description', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2"][vc_single_image style="vc_box_rounded"][/vc_column][vc_column width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/2"][/vc_column][vc_column width="1/2"][vc_tta_tabs][vc_tta_section title="Tab 1" tab_id="1441874172163-094e5af5-15d5"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Tab 2" tab_id="1441874172283-f430400e-9d32"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Description with accordion */
$data = array();
$data['name'] = esc_html__( 'Description with accordion', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h2|text_align:center" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text]
I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.
[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][vc_tta_accordion][vc_tta_section title="Section 1" tab_id="1441874023656-b1376fe8-b671"][vc_row_inner][vc_column_inner width="1/2"][vc_single_image style="vc_box_outline"][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_tta_section][vc_tta_section title="Section 2" tab_id="1441874023759-fa988392-b9ad"][vc_row_inner][vc_column_inner width="1/2"][vc_single_image style="vc_box_outline"][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_tta_section][/vc_tta_accordion][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Two column list */
$data = array();
$data['name'] = esc_html__( 'Two column list', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2"][vc_row_inner][vc_column_inner width="1/2"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][vc_row_inner][vc_column_inner width="1/2"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** About with tour section */
$data = array();
$data['name'] = esc_html__( 'About with tour section', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2"][vc_custom_heading text="This is custom heading element with Google Fonts" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_tta_tour][vc_tta_section title="Section 1" tab_id="1441873848705-137dadc4-4794"][vc_row_inner][vc_column_inner][vc_single_image alignment="center" style="vc_box_border"][vc_column_text]
I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_tta_section][vc_tta_section title="Section 2" tab_id="1441873848772-340367cb-2989"][vc_row_inner][vc_column_inner][vc_single_image alignment="center" style="vc_box_border"][vc_column_text]
I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_tta_section][/vc_tta_tour][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Rounded image description */
$data = array();
$data['name'] = esc_html__( 'Rounded image description', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/1"][vc_single_image alignment="center" style="vc_box_circle" border_color="grey" img_link_target="_self"][vc_column_text]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_single_image alignment="center" style="vc_box_circle" border_color="grey" img_link_target="_self"][vc_column_text]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][vc_column width="1/2"][vc_single_image alignment="center" style="vc_box_circle" border_color="grey" img_link_target="_self"][vc_column_text]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/3"][vc_single_image alignment="center" style="vc_box_circle" border_color="grey" img_link_target="_self"][vc_column_text]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image alignment="center" style="vc_box_circle" border_color="grey" img_link_target="_self"][vc_column_text]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image alignment="center" style="vc_box_circle" border_color="grey" img_link_target="_self"][vc_column_text]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Description with success message */
$data = array();
$data['name'] = esc_html__( 'Description with success message', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/1"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_message color="alert-success" style="rounded"]I am message box. Click edit button to change this text.[/vc_message][vc_row_inner][vc_column_inner width="1/2"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_circle"][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Images with tab description */
$data = array();
$data['name'] = esc_html__( 'Images with tab description', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/3"][vc_single_image alignment="center" style="vc_box_rounded"][/vc_column][vc_column width="1/3"][vc_single_image alignment="center" style="vc_box_rounded"][/vc_column][vc_column width="1/3"][vc_single_image alignment="center" style="vc_box_rounded"][/vc_column][/vc_row][vc_row][vc_column][vc_text_separator title="Title goes here"][/vc_column][/vc_row][vc_row][vc_column][vc_tta_tabs][vc_tta_section title="Tab 1" tab_id="1441874105744-0aeac9cb-3a3a"][vc_row_inner][vc_column_inner width="1/2"][vc_video][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_tta_section][vc_tta_section title="Tab 2" tab_id="1441874105862-625e36ff-76a2"][vc_row_inner][vc_column_inner width="1/2"][vc_single_image style="vc_box_rounded"][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_tta_section][/vc_tta_tabs][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Square on background */
$data = array();
$data['name'] = esc_html__( 'Square on background', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row full_width="" css=".vc_custom_1411477992738{background-color: #cecece !important;}"][vc_column width="1/1"][vc_empty_space height="200px"][vc_row_inner][vc_column_inner el_class="" width="1/3"][/vc_column_inner][vc_column_inner el_class="" width="1/3" css=".vc_custom_1411468859742{background-color: #ffffff !important;}"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h2|text_align:center|color:%23222222" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text css_animation=""]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][vc_cta h2="Hey! I am first heading line feel free to change me" h2_google_fonts="font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal" h4_google_fonts="font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal" txt_align="center" shape="rounded" style="classic" color="classic" add_button="bottom" btn_title="Try now" btn_style="flat" btn_shape="rounded" btn_color="juicy-pink" btn_size="md" btn_align="center" btn_i_align="left" btn_i_type="fontawesome" btn_i_icon_fontawesome="fas fa-adjust" btn_i_icon_openiconic="vc-oi vc-oi-dial" btn_i_icon_typicons="typcn typcn-adjust-brightness" btn_i_icon_entypo="entypo-icon entypo-icon-note" btn_i_icon_linecons="vc_li vc_li-heart" i_type="fontawesome" i_icon_fontawesome="fas fa-adjust" i_icon_openiconic="vc-oi vc-oi-dial" i_icon_typicons="typcn typcn-adjust-brightness" i_icon_entypo="entypo-icon entypo-icon-note" i_icon_linecons="vc_li vc_li-heart" i_color="blue" i_background_color="grey" i_size="md" use_custom_fonts_h2="" use_custom_fonts_h4="" btn_button_block="" btn_add_icon="" btn_i_icon_pixelicons="vc_pixel_icon vc_pixel_icon-alert" i_on_border=""]I am promo text. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_cta][/vc_column_inner][vc_column_inner el_class="" width="1/3"][/vc_column_inner][/vc_row_inner][vc_empty_space height="200px"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Product description with tabs */
$data = array();
$data['name'] = esc_html__( 'Product description with tabs', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2"][vc_single_image style="vc_box_rounded"][/vc_column][vc_column width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][vc_tta_tabs][vc_tta_section title="Tab 1" tab_id="1441874218694-385c7ca7-4943"][vc_row_inner][vc_column_inner width="1/2"][vc_video][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_tta_section][vc_tta_section title="Tab 2" tab_id="1441874218832-398800e3-835e"][vc_row_inner][vc_column_inner width="1/2"][vc_single_image style="vc_box_rounded"][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_tta_section][/vc_tta_tabs][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Description with headings */
$data = array();
$data['name'] = esc_html__( 'Description with headings', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row full_width=""][vc_column width="1/1"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h2|text_align:center" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text css_animation=""]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][/vc_row][vc_row full_width=""][vc_column width="1/1"][vc_separator color="grey" align="align_center" style="dashed" border_width="" el_width=""][/vc_column][/vc_row][vc_row full_width=""][vc_column width="1/2"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h3|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="flat" shape="round" color="sandy-brown" size="md" align="inline" i_align="left" i_type="fontawesome" i_icon_fontawesome="fas fa-adjust" i_icon_openiconic="vc-oi vc-oi-dial" i_icon_typicons="typcn typcn-adjust-brightness" i_icon_entypo="entypo-icon entypo-icon-note" i_icon_linecons="vc_li vc_li-heart" button_block="" add_icon="" i_icon_pixelicons="vc_pixel_icon vc_pixel_icon-alert"][/vc_column][vc_column width="1/2"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h3|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text css_animation=""]<p style="text-align: left;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][vc_btn title="Read more" style="flat" shape="round" color="sandy-brown" size="md" align="inline" i_align="left" i_type="fontawesome" i_icon_fontawesome="fas fa-adjust" i_icon_openiconic="vc-oi vc-oi-dial" i_icon_typicons="typcn typcn-adjust-brightness" i_icon_entypo="entypo-icon entypo-icon-note" i_icon_linecons="vc_li vc_li-heart" css_animation="" button_block="" add_icon="" i_icon_pixelicons="vc_pixel_icon vc_pixel_icon-alert"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Video description */
$data = array();
$data['name'] = esc_html__( 'Video with description', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/6"][/vc_column][vc_column width="4/6"][vc_video][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/1"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/1"][vc_separator color="grey" style="dotted"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_row_inner][vc_column_inner width="1/2"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][vc_row_inner][vc_column_inner width="1/2"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Description with buttons */
$data = array();
$data['name'] = esc_html__( 'Description with buttons', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row full_width=""][vc_column width="1/1"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h2|text_align:center" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text css_animation=""]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][/vc_row][vc_row full_width=""][vc_column width="1/2"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h3|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="3d" shape="rounded" color="chino" size="md" align="inline" i_align="left" i_type="fontawesome" i_icon_fontawesome="fas fa-adjust" i_icon_openiconic="vc-oi vc-oi-dial" i_icon_typicons="typcn typcn-adjust-brightness" i_icon_entypo="entypo-icon entypo-icon-note" i_icon_linecons="vc_li vc_li-heart" button_block="" add_icon="" i_icon_pixelicons="vc_pixel_icon vc_pixel_icon-alert"][/vc_column][vc_column width="1/2"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h3|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="3d" shape="rounded" color="chino" size="md" align="inline" i_align="left" i_type="fontawesome" i_icon_fontawesome="fas fa-adjust" i_icon_openiconic="vc-oi vc-oi-dial" i_icon_typicons="typcn typcn-adjust-brightness" i_icon_entypo="entypo-icon entypo-icon-note" i_icon_linecons="vc_li vc_li-heart" css_animation="" button_block="" add_icon="" i_icon_pixelicons="vc_pixel_icon vc_pixel_icon-alert"][/vc_column][/vc_row][vc_row full_width=""][vc_column width="1/3"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h4|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="3d" shape="rounded" color="chino" size="md" align="inline" i_align="left" i_type="fontawesome" i_icon_fontawesome="fas fa-adjust" i_icon_openiconic="vc-oi vc-oi-dial" i_icon_typicons="typcn typcn-adjust-brightness" i_icon_entypo="entypo-icon entypo-icon-note" i_icon_linecons="vc_li vc_li-heart" css_animation="" button_block="" add_icon="" i_icon_pixelicons="vc_pixel_icon vc_pixel_icon-alert"][/vc_column][vc_column width="1/3"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h4|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="3d" shape="rounded" color="chino" size="md" align="inline" i_align="left" i_type="fontawesome" i_icon_fontawesome="fas fa-adjust" i_icon_openiconic="vc-oi vc-oi-dial" i_icon_typicons="typcn typcn-adjust-brightness" i_icon_entypo="entypo-icon entypo-icon-note" i_icon_linecons="vc_li vc_li-heart" css_animation="" button_block="" add_icon="" i_icon_pixelicons="vc_pixel_icon vc_pixel_icon-alert"][/vc_column][vc_column width="1/3"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h4|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="3d" shape="rounded" color="chino" size="md" align="inline" i_align="left" i_type="fontawesome" i_icon_fontawesome="fas fa-adjust" i_icon_openiconic="vc-oi vc-oi-dial" i_icon_typicons="typcn typcn-adjust-brightness" i_icon_entypo="entypo-icon entypo-icon-note" i_icon_linecons="vc_li vc_li-heart" css_animation="" button_block="" add_icon="" i_icon_pixelicons="vc_pixel_icon vc_pixel_icon-alert"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Map and Contacts */
$data = array();
$data['name'] = esc_html__( 'Map and Contacts', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/1"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h2|text_align:center" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_row_inner][vc_column_inner width="2/3"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column width="1/1"][vc_gmaps size="300"][/vc_column][/vc_row][vc_row][vc_column width="1/1"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h2|text_align:center" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Help section */
$data = array();
$data['name'] = esc_html__( 'Help section', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2"][vc_toggle title="First question" open="false"]Toggle content goes here, click edit button to change this text.[/vc_toggle][vc_toggle title="Second question" open="false"]Toggle content goes here, click edit button to change this text.[/vc_toggle][vc_toggle title="Third question" open="false"]Toggle content goes here, click edit button to change this text.[/vc_toggle][/vc_column][vc_column width="1/2"][vc_toggle title="Fourth question" open="false"]Toggle content goes here, click edit button to change this text.[/vc_toggle][vc_toggle title="Fifth question" open="false"]Toggle content goes here, click edit button to change this text.[/vc_toggle][vc_toggle title="Sixth question" open="false"]Toggle content goes here, click edit button to change this text.[/vc_toggle][/vc_column][/vc_row][vc_row][vc_column width="1/1"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h3|text_align:center" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Screen description */
$data = array();
$data['name'] = esc_html__( 'Screen description', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/4"][vc_row_inner][vc_column_inner width="1/1"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h3|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="2/4"][vc_single_image alignment="center" border_color="grey" img_link_target="_self"][/vc_column][vc_column width="1/4"][vc_row_inner][vc_column_inner width="1/1"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h3|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Description with round images*/
$data = array();
$data['name'] = esc_html__( 'Description with round images', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/1"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h2|text_align:center" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/3"][vc_single_image alignment="center" style="vc_box_circle" border_color="grey" img_link_target="_self"][/vc_column][vc_column width="1/3"][vc_single_image alignment="center" style="vc_box_circle" border_color="grey" img_link_target="_self"][/vc_column][vc_column width="1/3"][vc_single_image alignment="center" style="vc_box_circle" border_color="grey" img_link_target="_self"][/vc_column][/vc_row][vc_row][vc_column width="1/1"][vc_column_text]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** FAQ in three columns */
$data = array();
$data['name'] = esc_html__( 'FAQ in three columns', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/1"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h2|text_align:center" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/1"][vc_separator color="grey" style="double"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][vc_toggle title="First question" open="false"]Toggle content goes here, click edit button to change this text.[/vc_toggle][vc_toggle title="Second question" open="false"]Toggle content goes here, click edit button to change this text.[/vc_toggle][/vc_column][vc_column width="1/3"][vc_toggle title="Third question" open="false"]Toggle content goes here, click edit button to change this text.[/vc_toggle][vc_toggle title="Fourth question" open="false"]Toggle content goes here, click edit button to change this text.[/vc_toggle][/vc_column][vc_column width="1/3"][vc_toggle title="Fifth question" open="false"]Toggle content goes here, click edit button to change this text.[/vc_toggle][vc_toggle title="Sixth question" open="false"]Toggle content goes here, click edit button to change this text.[/vc_toggle][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Centre description */
$data = array();
$data['name'] = esc_html__( 'Centre description', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1411476739640{padding-top: 50px !important;padding-bottom: 50px !important;background-color: #e8e8e8 !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/1"][vc_row_inner][vc_column_inner width="1/3"][/vc_column_inner][vc_column_inner width="1/3"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h2|text_align:center" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Description with gallery */
$data = array();
$data['name'] = esc_html__( 'Description with gallery', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/3"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h2|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_outline" alignment="center"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_outline" alignment="center"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_outline" alignment="center"][/vc_column][vc_column width="1/3"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_outline" alignment="center"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_outline" alignment="center"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_outline" alignment="center"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Centre description with image */
$data = array();
$data['name'] = esc_html__( 'Centre description with image', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row css=".vc_custom_1411476638326{padding-top: 50px !important;padding-bottom: 50px !important;background-color: #eaeaea !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/1"][vc_row_inner][vc_column_inner width="1/3"][/vc_column_inner][vc_column_inner width="1/3"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h3|text_align:center" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][/vc_column_inner][vc_column_inner width="1/3"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Description with thumbnails */
$data = array();
$data['name'] = esc_html__( 'Description with thumbnails', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/1"][vc_column_text]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/4"][vc_single_image alignment="center" border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column][vc_column width="1/4"][vc_single_image alignment="center" border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column][vc_column width="1/4"][vc_single_image alignment="center" border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column][vc_column width="1/4"][vc_single_image alignment="center" border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column][/vc_row][vc_row][vc_column width="1/4"][vc_single_image alignment="center" border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column][vc_column width="1/4"][vc_single_image alignment="center" border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column][vc_column width="1/4"][vc_single_image alignment="center" border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column][vc_column width="1/4"][vc_single_image alignment="center" border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column][/vc_row][vc_row][vc_column width="1/1"][vc_column_text]<p style="text-align: center;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</p>[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** About with left gallery */
$data = array();
$data['name'] = esc_html__( 'About with left gallery', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/4"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][/vc_column][vc_column width="3/4"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h2|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Five image layout */
$data = array();
$data['name'] = esc_html__( 'Five image layout', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="2/3"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_row_inner][vc_column_inner width="1/2"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/3"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_rounded"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Accordion news list */
$data = array();
$data['name'] = esc_html__( 'Accordion news list', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column][vc_tta_accordion][vc_tta_section title="Section 1" tab_id="1441873920568-18a8a48a-7614"][vc_row_inner][vc_column_inner width="1/4"][vc_single_image alignment="" style="vc_box_rounded"][/vc_column_inner][vc_column_inner width="3/4"][vc_custom_heading text="This is custom heading element with Google Fonts" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="flat" color="juicy-pink"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/4"][vc_single_image alignment="" style="vc_box_rounded"][/vc_column_inner][vc_column_inner width="3/4"][vc_custom_heading text="This is custom heading element with Google Fonts" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="flat" color="juicy-pink"][/vc_column_inner][/vc_row_inner][/vc_tta_section][vc_tta_section title="Section 2" tab_id="1441873920660-a173daba-0456"][vc_row_inner][vc_column_inner width="1/4"][vc_single_image alignment="" style="vc_box_rounded"][/vc_column_inner][vc_column_inner width="3/4"][vc_custom_heading text="This is custom heading element with Google Fonts" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="flat" color="juicy-pink"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/4"][vc_single_image alignment="" style="vc_box_rounded"][/vc_column_inner][vc_column_inner width="3/4"][vc_custom_heading text="This is custom heading element with Google Fonts" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="flat" color="juicy-pink"][/vc_column_inner][/vc_row_inner][/vc_tta_section][/vc_tta_accordion][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Product with social icons */
$data = array();
$data['name'] = esc_html__( 'Product with social icons', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row][vc_column width="1/2"][vc_single_image border_color="grey" img_link_target="_self" style="vc_box_border"][/vc_column][vc_column width="1/2"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h2|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_row_inner][vc_column_inner width="1/3"][vc_facebook type="standard"][/vc_column_inner][vc_column_inner width="1/3"][vc_tweetmeme type="none"][/vc_column_inner][vc_column_inner width="1/3"][vc_googleplus annotation="none"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Complex news layout */
$data = array();
$data['name'] = esc_html__( 'Complex news layout', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row full_width=""][vc_column width="2/3"][vc_row_inner][vc_column_inner el_class="" width="1/2"][vc_single_image image="" alignment="" style="vc_box_border" border_color="grey" img_link_large="" img_link_target="_self" css_animation=""][/vc_column_inner][vc_column_inner el_class="" width="1/2"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h2|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="flat" shape="rounded" color="mulled-wine" size="md" align="inline" i_align="left" i_type="fontawesome" i_icon_fontawesome="fas fa-adjust" i_icon_openiconic="vc-oi vc-oi-dial" i_icon_typicons="typcn typcn-adjust-brightness" i_icon_entypo="entypo-icon entypo-icon-note" i_icon_linecons="vc_li vc_li-heart" button_block="" add_icon="" i_icon_pixelicons="vc_pixel_icon vc_pixel_icon-alert"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner el_class="" width="1/2"][vc_single_image image="" alignment="" style="vc_box_border" border_color="grey" img_link_large="" img_link_target="_self" css_animation=""][/vc_column_inner][vc_column_inner el_class="" width="1/2"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h2|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_btn title="Read more" style="flat" shape="rounded" color="mulled-wine" size="md" align="inline" i_align="left" i_type="fontawesome" i_icon_fontawesome="fas fa-adjust" i_icon_openiconic="vc-oi vc-oi-dial" i_icon_typicons="typcn typcn-adjust-brightness" i_icon_entypo="entypo-icon entypo-icon-note" i_icon_linecons="vc_li vc_li-heart" css_animation="" button_block="" add_icon="" i_icon_pixelicons="vc_pixel_icon vc_pixel_icon-alert"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/3"][vc_row_inner][vc_column_inner el_class="" width="1/1"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h3|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner el_class="" width="1/1"][vc_custom_heading text="This is custom heading element with Google Fonts" font_container="tag:h3|text_align:left" google_fonts="font_family:Montserrat%3Aregular%2C700|font_style:400%20regular%3A400%3Anormal"][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

/** Product list with CTA */
$data = array();
$data['name'] = esc_html__( 'Product list with CTA', 'js_composer' );
$data['disabled'] = true;
$data['content'] = <<<CONTENT
[vc_row full_width=""][vc_column width="1/3"][vc_single_image image="" alignment="" style="vc_box_outline" border_color="grey" img_link_large="" img_link_target="_self" css_animation=""][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image image="" alignment="" style="vc_box_outline" border_color="grey" img_link_large="" img_link_target="_self" css_animation=""][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image image="" alignment="" style="vc_box_outline" border_color="grey" img_link_large="" img_link_target="_self" css_animation=""][vc_column_text css_animation=""]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row][vc_row full_width=""][vc_column width="1/1"