<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Elementor Blog Posts Element.
 */
class Maxhost_Elementor_Htab_01 extends \Elementor\Widget_Base {

    /**
     * Get Element name.
     *
     * Retrieve element name.
     * @return string Element name.
     */
    public function get_name() {
        return 'maxhost_elementor_htab_01';
    }

    /**
     * Get element title
     *
     * @return string Element title
     */
    public function get_title() {
        return esc_html__( 'Horizontal Tabs 01', 'maxhost' );
    }

    /**
     * Get element icon
     *
     * @return string Element icon
     */
    public function get_icon() {
        return 'eicon-tabs';
    }

    /**
     * Get element categories
     *
     * Retrieve the list of categories the element belongs to
     *
     * @return array Element categories
     */
    public function get_categories() {
        return [ 'maxhost-elements' ];
    }

    /**
     * Register element controls
     * Adds different input fields to allow the user to change and customize the element settings
     */
    protected function register_controls() {

        $this->start_controls_section(
            'general_section',
            [
                'label'     => esc_html__( 'General', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'maxhost_shortcodes_parallax_bg',
            [
                'label'     => esc_html__( 'Section Background Image URL', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'shape_top',
            [
                'label'     => esc_html__( 'Curved Shaped Section Top', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'description' => '',
				'return_value' => 'false',
				'default' => 'false',
            ]
        );
		
		$this->add_control(
            'number_of_tabs',
            [
                'label'     => esc_html__('Number of Tabs', 'maxhost'),
                'type' => \Elementor\Controls_Manager::SELECT,
				'options'   => [
                    '1' => esc_html__('One', 'maxhost'),
                    '2' => esc_html__('Two', 'maxhost'),
                    '3' => esc_html__('Three', 'maxhost'),
                    '4' => esc_html__('Four', 'maxhost'),
                ],
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();

        $this->start_controls_section(
            'tab01_section',
            [
                'label'     => esc_html__( 'Tab 01', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'title1',
            [
                'label'     => esc_html__( 'Tab-01 Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'icon1',
            [
                'label'     => esc_html__( 'Tab-01 Icon', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Icon list - ', 'maxhost').'<a href="http://www.imdrt.org/2018experience/Fonts/et-line-icons/demo.html" target="_blank">'.esc_html__('refer here', 'maxhost').'</a>',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id1',
			[
				'label' => esc_html__( 'Tab-01 Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->add_control(
            'title_one1',
            [
                'label'     => esc_html__( 'Tab-01 Title (Colored)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'title_two1',
            [
                'label'     => esc_html__( 'Tab-01 Title (White)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text1',
            [
                'label'     => esc_html__( 'Tab-01 Text', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'bullets1',
            [
                'label'     => esc_html__( 'Tab-01 Bullet Points', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('Start each bullet point on new line','maxhost'),
                'default' => '',
            ]
        );
		
		$this->add_control(
            'bottom_note1',
            [
                'label'     => esc_html__( 'Tab-01 Bottom Note', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'tab02_section',
            [
                'label'     => esc_html__( 'Tab 02', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'title2',
            [
                'label'     => esc_html__( 'Tab-02 Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'icon2',
            [
                'label'     => esc_html__( 'Tab-02 Icon', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Icon list - ', 'maxhost').'<a href="http://www.imdrt.org/2018experience/Fonts/et-line-icons/demo.html" target="_blank">'.esc_html__('refer here', 'maxhost').'</a>',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id2',
			[
				'label' => esc_html__( 'Tab-02 Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->add_control(
            'title_one2',
            [
                'label'     => esc_html__( 'Tab-02 Title (Colored)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'title_two2',
            [
                'label'     => esc_html__( 'Tab-02 Title (White)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text2',
            [
                'label'     => esc_html__( 'Tab-02 Text', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'bullets2',
            [
                'label'     => esc_html__( 'Tab-02 Bullet Points', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('Start each bullet point on new line','maxhost'),
                'default' => '',
            ]
        );
		
		$this->add_control(
            'bottom_note2',
            [
                'label'     => esc_html__( 'Tab-02 Bottom Note', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'tab03_section',
            [
                'label'     => esc_html__( 'Tab 03', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'title3',
            [
                'label'     => esc_html__( 'Tab-03 Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'icon3',
            [
                'label'     => esc_html__( 'Tab-03 Icon', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Icon list - ', 'maxhost').'<a href="http://www.imdrt.org/2018experience/Fonts/et-line-icons/demo.html" target="_blank">'.esc_html__('refer here', 'maxhost').'</a>',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id3',
			[
				'label' => esc_html__( 'Tab-03 Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->add_control(
            'title_one3',
            [
                'label'     => esc_html__( 'Tab-03 Title (Colored)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'title_two3',
            [
                'label'     => esc_html__( 'Tab-03 Title (White)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text3',
            [
                'label'     => esc_html__( 'Tab-03 Text', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'bullets3',
            [
                'label'     => esc_html__( 'Tab-03 Bullet Points', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('Start each bullet point on new line','maxhost'),
                'default' => '',
            ]
        );
		
		$this->add_control(
            'bottom_note3',
            [
                'label'     => esc_html__( 'Tab-03 Bottom Note', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();
		
		$this->start_controls_section(
            'tab04_section',
            [
                'label'     => esc_html__( 'Tab 04', 'maxhost' ),
                'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
		
		$this->add_control(
            'title4',
            [
                'label'     => esc_html__( 'Tab-04 Heading', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'icon4',
            [
                'label'     => esc_html__( 'Tab-04 Icon', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => esc_html__('Icon list - ', 'maxhost').'<a href="http://www.imdrt.org/2018experience/Fonts/et-line-icons/demo.html" target="_blank">'.esc_html__('refer here', 'maxhost').'</a>',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
			'img_one_elementor_id4',
			[
				'label' => esc_html__( 'Tab-04 Image', 'maxhost' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'id' => '',
				],
				'label_block' => true,
			]
		);
		
		$this->add_control(
            'title_one4',
            [
                'label'     => esc_html__( 'Tab-04 Title (Colored)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'title_two4',
            [
                'label'     => esc_html__( 'Tab-04 Title (White)', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->add_control(
            'text4',
            [
                'label'     => esc_html__( 'Tab-04 Text', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => '',
                'default' => '',
            ]
        );
		
		$this->add_control(
            'bullets4',
            [
                'label'     => esc_html__( 'Tab-04 Bullet Points', 'maxhost' ),             
				'type' => \Elementor\Controls_Manager::TEXTAREA,
                'description' => esc_html__('Start each bullet point on new line','maxhost'),
                'default' => '',
            ]
        );
		
		$this->add_control(
            'bottom_note4',
            [
                'label'     => esc_html__( 'Tab-04 Bottom Note', 'maxhost' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'description' => '',
                'default' => '',
				'label_block' => true,
            ]
        );
		
		$this->end_controls_section();

    }

    /**
     * Render element output on the frontend.
     *
     * Written in PHP and used to generate the final HTML
     */
    protected function render() {

        $settings = $this->get_settings_for_display();

        $args['maxhost_shortcodes_parallax_bg'] =  $settings['maxhost_shortcodes_parallax_bg'];
		$args['shape_top'] =  $settings['shape_top'];
		$args['number_of_tabs'] =  $settings['number_of_tabs'];
		$args['title1'] =  $settings['title1'];
		$args['icon1'] =  $settings['icon1'];
		$args['img_one_elementor_id1'] =  $settings['img_one_elementor_id1'];
		$args['title_one1'] =  $settings['title_one1'];
		$args['title_two1'] =  $settings['title_two1'];
		$args['text1'] =  $settings['text1'];
		$args['bullets1'] =  $settings['bullets1'];
		$args['bottom_note1'] =  $settings['bottom_note1'];
		$args['title2'] =  $settings['title2'];
		$args['icon2'] =  $settings['icon2'];
		$args['img_one_elementor_id2'] =  $settings['img_one_elementor_id2'];
		$args['title_one2'] =  $settings['title_one2'];
		$args['title_two2'] =  $settings['title_two2'];
		$args['text2'] =  $settings['text2'];
		$args['bullets2'] =  $settings['bullets2'];
		$args['bottom_note2'] =  $settings['bottom_note2'];
		$args['title3'] =  $settings['title3'];
		$args['icon3'] =  $settings['icon3'];
		$args['img_one_elementor_id3'] =  $settings['img_one_elementor_id3'];
		$args['title_one3'] =  $settings['title_one3'];
		$args['title_two3'] =  $settings['title_two3'];
		$args['text3'] =  $settings['text3'];
		$args['bullets3'] =  $settings['bullets3'];
		$args['bottom_note3'] =  $settings['bottom_note3'];
		$args['title4'] =  $settings['title4'];
		$args['icon4'] =  $settings['icon4'];
		$args['img_one_elementor_id4'] =  $settings['img_one_elementor_id4'];
		$args['title_one4'] =  $settings['title_one4'];
		$args['title_two4'] =  $settings['title_two4'];
		$args['text4'] =  $settings['text4'];
		$args['bullets4'] =  $settings['bullets4'];
		$args['bottom_note4'] =  $settings['bottom_note4'];
		
        if( function_exists( 'maxhost_htab_shortcode' ) ) {
            echo maxhost_htab_shortcode( $args );
        }

    }

}